/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.karaf.camel.itests.ExternalResource;
import org.apache.karaf.camel.itests.Utils;

public class AvailablePortProvider
implements ExternalResource {
    private static final Set<Integer> USED_PORTS = ConcurrentHashMap.newKeySet();
    private final Map<String, Integer> ports = new ConcurrentHashMap<String, Integer>();
    private final List<String> neededPortPropertyNames;

    public AvailablePortProvider(List<String> neededPortPropertyNames) {
        this.neededPortPropertyNames = neededPortPropertyNames;
    }

    @Override
    public void before() {
        for (String name : this.neededPortPropertyNames) {
            Utils.getNextAvailablePort(port -> {
                if (USED_PORTS.add(port)) {
                    this.ports.put(name, port);
                    return true;
                }
                return false;
            });
        }
    }

    @Override
    public void after() {
        this.ports.values().forEach(USED_PORTS::remove);
    }

    @Override
    public Map<String, String> properties() {
        return this.ports.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Integer)e.getValue()).toString()));
    }
}

