/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.camel.itests.CamelSingleFeatureRoute;
import org.awaitility.Awaitility;
import org.junit.Assert;

public interface CamelSingleFeatureResultFileBasedRoute
extends CamelSingleFeatureRoute {
    default public String getResultFileName() {
        return this.getTestComponentName();
    }

    default public Charset getResultFileCharset() {
        return StandardCharsets.UTF_8;
    }

    default public Path assertResultFileExists() {
        Path filePath = Path.of(this.getBaseDir(), this.getResultFileName());
        Awaitility.await().atMost((long)this.getTimeoutInSeconds(), TimeUnit.SECONDS).until(() -> Files.exists(filePath, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(filePath, new LinkOption[0]));
        return filePath;
    }

    default public void assertResultFileContains(String expectedFileContent) throws Exception {
        Assert.assertEquals((String)"The content of the result file is not correct", (Object)expectedFileContent, (Object)Files.readString(this.assertResultFileExists(), this.getResultFileCharset()));
    }

    default public void assertResultFileIsSameAs(String expectedResultFileName) throws Exception {
        this.assertResultFileContains(Files.readString(this.createExpectedResultPath(expectedResultFileName)));
    }

    default public void assertResultFileIsSameAs(String expectedResultFileName, Charset encoding) throws Exception {
        this.assertResultFileContains(Files.readString(this.createExpectedResultPath(expectedResultFileName), encoding));
    }

    default public Path createExpectedResultPath(String expectedResultFileName) {
        return Path.of(this.getBaseDir(), "test-classes", expectedResultFileName);
    }

    public String getBaseDir();
}

