/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.karaf.camel.itests.Utils;
import org.jetbrains.annotations.NotNull;

public interface CamelSingleFeatureRoute {
    default public int getTimeoutInSeconds() {
        return 5;
    }

    default public String getTestComponentName() {
        return this.getTestClassSimpleNameInKebabCase().replace("-itest", "-test");
    }

    default public String getCamelFeatureName() {
        return this.getTestClassSimpleNameInKebabCase().replace("-itest", "");
    }

    @NotNull
    private String getTestClassSimpleNameInKebabCase() {
        String name = Utils.toKebabCase(this.getClass().getSimpleName());
        if (!name.endsWith("-itest")) {
            throw new IllegalArgumentException("The integration test class name doesn't match with the expected format: <tested-camel-component-name>ITest");
        }
        return name;
    }

    default public String getTestBundleName() {
        return this.getTestComponentName();
    }

    default public List<String> getRequiredFeatures() {
        return List.of(this.getCamelFeatureName());
    }

    default public Processor getProcessorToCallOnSend() {
        return exchange -> exchange.getMessage().setBody((Object)this.getBodyToSend());
    }

    default public String getBodyToSend() {
        return this.getClass().getSimpleName();
    }

    public CamelContext getContext();

    public ProducerTemplate getTemplate();

    default public void triggerProducerRoute() {
        Endpoint endpoint = this.getContext().hasEndpoint("direct:%s".formatted(this.getTestComponentName()));
        if (endpoint != null) {
            this.getTemplate().send(endpoint, this.getProcessorToCallOnSend());
        }
    }
}

