/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.karaf.camel.itests.AbstractCamelRouteLauncher;
import org.apache.karaf.camel.itests.CamelKarafTestHint;
import org.apache.karaf.camel.itests.CamelRouteSupplier;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CamelKarafTestHint(camelContextName="supplied-route-launcher")
@Component(name="camel-supplied-route-launcher", immediate=true)
public class CamelSuppliedRouteLauncher
extends AbstractCamelRouteLauncher
implements ServiceListener {
    public static final String CAMEL_CONTEXT_NAME = "supplied-route-launcher";
    private static final Logger LOG = LoggerFactory.getLogger(CamelSuppliedRouteLauncher.class);
    private final Map<String, List<RouteDefinition>> routes = new ConcurrentHashMap<String, List<RouteDefinition>>();
    private final Set<String> suppliers = ConcurrentHashMap.newKeySet();
    private boolean ignoreSuppliers;

    @Override
    public void activate(ComponentContext componentContext) throws Exception {
        super.activate(componentContext);
        this.camelContext.getBundleContext().addServiceListener((ServiceListener)this);
        this.loadSuppliers();
    }

    @Override
    public void deactivate() {
        this.suppliers.clear();
        super.deactivate();
    }

    private void loadSuppliers() {
        String ignoreProperty = System.getProperty("camel.karaf.itest.ignore.route.suppliers");
        if (ignoreProperty != null) {
            this.ignoreSuppliers = true;
            return;
        }
        String property = System.getProperty("camel.karaf.itest.route.suppliers");
        if (property == null) {
            return;
        }
        this.suppliers.addAll(List.of(property.split(",")));
    }

    private boolean ignore(ServiceReference<?> serviceReference) {
        boolean result = false;
        if (this.ignoreSuppliers) {
            result = true;
        } else if (!this.suppliers.isEmpty()) {
            Object componentName = serviceReference.getProperty("component.name");
            result = componentName != null && !this.suppliers.contains(componentName);
        }
        return result;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
            }
        };
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object object;
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        if (this.ignore(serviceReference)) {
            LOG.debug("Ignoring CamelRouteSupplier service: {}", (Object)serviceReference.getProperties());
            return;
        }
        if (serviceEvent.getType() == 1) {
            Object object2 = this.camelContext.getBundleContext().getService(serviceReference);
            if (object2 instanceof CamelRouteSupplier) {
                CamelRouteSupplier supplier = (CamelRouteSupplier)object2;
                LOG.info("CamelRouteSupplier service registered: {} from the class {}", (Object)serviceReference.getProperties(), (Object)supplier.getClass().getName());
                this.addRoutes(supplier);
            }
        } else if (serviceEvent.getType() == 4 && (object = this.camelContext.getBundleContext().getService(serviceReference)) instanceof CamelRouteSupplier) {
            CamelRouteSupplier supplier = (CamelRouteSupplier)object;
            LOG.info("CamelRouteSupplier service unregistered: {}", (Object)supplier.getClass().getName());
            this.removeRoutes(supplier);
        }
    }

    private void removeRoutes(CamelRouteSupplier supplier) {
        try {
            List<RouteDefinition> routeDefinitions = this.routes.remove(supplier.getClass().getName());
            if (routeDefinitions == null) {
                return;
            }
            this.camelContext.removeRouteDefinitions(routeDefinitions);
            supplier.cleanUp((CamelContext)this.camelContext);
            LOG.info("Route(s) removed from CamelRouteSupplier service: {}", (Object)supplier.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addRoutes(final CamelRouteSupplier supplier) {
        try {
            ArrayList before = new ArrayList(this.camelContext.getRouteDefinitions());
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    supplier.configure((CamelContext)CamelSuppliedRouteLauncher.this.camelContext);
                    supplier.createRoutes(this);
                }
            });
            ArrayList added = new ArrayList(this.camelContext.getRouteDefinitions());
            added.removeAll(before);
            if (this.routes.putIfAbsent(supplier.getClass().getName(), added) == null) {
                LOG.info("Route(s) created from CamelRouteSupplier service: {}", (Object)supplier.getClass().getName());
            } else {
                LOG.warn("Route(s) already created from CamelRouteSupplier service: {}", (Object)supplier.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

