/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.io.File;
import java.io.PrintStream;
import org.apache.karaf.camel.itests.Utils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DumpFileOnError
implements TestRule {
    private final PrintStream out;
    private final File file;
    private final boolean enabled;

    public DumpFileOnError(File file, PrintStream out, boolean enabled) {
        this.file = file;
        this.out = out;
        this.enabled = enabled;
    }

    public Statement apply(final Statement statement, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                catch (Throwable t) {
                    if (DumpFileOnError.this.enabled) {
                        Utils.dumpFile(DumpFileOnError.this.file, DumpFileOnError.this.out);
                    }
                    throw t;
                }
            }
        };
    }
}

