/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.camel.itests.ExternalResource;

public abstract class ExternalResourceWithPrerequisite
implements ExternalResource {
    private final Map<String, String> properties = new HashMap<String, String>();

    @Override
    public void before() {
        for (ExternalResource prerequisite : this.getPrerequisites()) {
            prerequisite.before();
            prerequisite.properties().forEach(this::setProperty);
        }
        this.doStart();
    }

    @Override
    public void after() {
        this.doStop();
        for (ExternalResource prerequisite : this.getPrerequisites()) {
            prerequisite.after();
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    protected abstract List<ExternalResource> getPrerequisites();

    protected abstract void doStart();

    protected abstract void doStop();
}

