/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.karaf.camel.itests.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.ResourceReaper;

public class GenericContainerResource<T extends GenericContainer<T>>
implements ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(GenericContainerResource.class);
    private static final String CAMEL_KARAF_INTEGRATION_TEST_KEEP_DOCKER_IMAGES_PROPERTY = "camel.karaf.itest.keep.docker.images";
    private final T container;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final List<ExternalResource> dependencies = new ArrayList<ExternalResource>();
    private final Consumer<GenericContainerResource<T>> onStarted;

    public GenericContainerResource(T container) {
        this(container, t -> {});
    }

    public GenericContainerResource(T container, Consumer<GenericContainerResource<T>> onStarted) {
        this.container = container;
        this.onStarted = onStarted;
    }

    @Override
    public void before() {
        this.container.start();
        this.onStarted.accept(this);
        for (ExternalResource dependency : this.dependencies) {
            dependency.before();
            dependency.properties().forEach(this::setProperty);
        }
        LOG.info("Container {}/{} started", (Object)this.container.getDockerImageName(), (Object)this.container.getContainerId());
    }

    @Override
    public void after() {
        for (ExternalResource dependency : this.dependencies) {
            try {
                dependency.after();
            }
            catch (Exception e) {
                LOG.warn("Error cleaning dependency: {}", (Object)dependency.getClass().getName(), (Object)e);
            }
        }
        String containerId = this.container.getContainerId();
        this.container.stop();
        LOG.info("Container {}/{} stopped", (Object)this.container.getDockerImageName(), (Object)containerId);
        if (GenericContainerResource.cleanupDockerImagesOnExit()) {
            this.removeDockerImage();
        }
    }

    private void removeDockerImage() {
        ResourceReaper resourceReaper = ResourceReaper.instance();
        String dockerImageName = this.container.getDockerImageName();
        resourceReaper.registerImageForCleanup(dockerImageName);
        resourceReaper.performCleanup();
        LOG.info("Docker Image {} removed", (Object)dockerImageName);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public T getContainer() {
        return this.container;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void addDependency(ExternalResource dependency) {
        this.dependencies.add(dependency);
    }

    private static boolean cleanupDockerImagesOnExit() {
        return !Boolean.parseBoolean(System.getProperty(CAMEL_KARAF_INTEGRATION_TEST_KEEP_DOCKER_IMAGES_PROPERTY, "false"));
    }
}

