/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.karaf.camel.itests.CamelKarafTestHint;
import org.apache.karaf.camel.itests.ExternalResource;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.junit.impl.ProbeRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxExamWithExternalResource
extends Runner
implements Filterable,
Sortable {
    private static final Logger LOG = LoggerFactory.getLogger(PaxExamWithExternalResource.class);
    private static final ThreadLocal<PaxExamWithExternalResource> current = new ThreadLocal();
    private final ParentRunner<?> delegate;
    private final List<ExternalResource> externalResources;

    public PaxExamWithExternalResource(Class<?> testClass) throws InitializationError, InvocationTargetException, IllegalAccessException {
        this.externalResources = this.beforeAll(testClass);
        try {
            current.set(this);
            this.delegate = new ProbeRunner(testClass);
        }
        finally {
            current.remove();
        }
    }

    private List<ExternalResource> beforeAll(Class<?> testClass) throws InvocationTargetException, IllegalAccessException {
        CamelKarafTestHint annotation = testClass.getAnnotation(CamelKarafTestHint.class);
        if (annotation != null && annotation.externalResourceProvider() != Object.class) {
            ArrayList<ExternalResource> result = new ArrayList<ExternalResource>();
            for (Method m : annotation.externalResourceProvider().getMethods()) {
                if (!this.isExternalResourceSupplier(m)) continue;
                ExternalResource externalResource = (ExternalResource)m.invoke(null, new Object[0]);
                externalResource.before();
                result.add(externalResource);
            }
            return result;
        }
        LOG.warn("Class {} is not annotated with @CamelKarafTestHint or externalResourceProvider is not set", (Object)testClass.getName());
        return List.of();
    }

    private boolean isExternalResourceSupplier(Method m) {
        return ExternalResource.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 0 && Modifier.isStatic(m.getModifiers());
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        try {
            this.delegate.run(notifier);
        }
        finally {
            this.afterAll();
        }
    }

    private void afterAll() {
        for (int i = this.externalResources.size() - 1; i >= 0; --i) {
            try {
                this.externalResources.get(i).after();
                continue;
            }
            catch (Exception e) {
                LOG.warn("Error while cleaning up external resource", (Throwable)e);
            }
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.delegate.filter(filter);
    }

    public void sort(Sorter sorter) {
        this.delegate.sort(sorter);
    }

    static Map<String, String> systemProperties() {
        PaxExamWithExternalResource value = current.get();
        if (value == null) {
            return Map.of();
        }
        return value.externalResources.stream().map(ExternalResource::properties).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

