/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.karaf.camel.itests.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFile
implements ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryFile.class);
    private final String key;
    private final Path path;

    public TemporaryFile(String key, String prefix, String suffix) throws IOException {
        this.key = key;
        this.path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    @Override
    public void before() {
    }

    @Override
    public void after() {
        try {
            if (Files.deleteIfExists(this.path)) {
                LOG.debug("Deleted temporary file: {}", (Object)this.path);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to delete temporary file: {}", (Object)this.path, (Object)e);
        }
    }

    @Override
    public Map<String, String> properties() {
        return Map.of(this.key, this.path.toString());
    }

    public Path getPath() {
        return this.path;
    }
}

