/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.karaf.camel.itests.Utils;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.spi.PaxExamRuntime;
import org.ops4j.pax.exam.util.PathUtils;

public class TestContainerFactoryFailureAware
implements TestContainerFactory {
    private final boolean enabled = Boolean.getBoolean("camel.karaf.itest.dump.logs");
    private final TestContainerFactory delegate = PaxExamRuntime.getTestContainerFactory();

    public TestContainer[] create(ExamSystem system) {
        TestContainer[] containers = this.delegate.create(system);
        if (this.enabled) {
            for (int i = 0; i < containers.length; ++i) {
                containers[i] = new TestContainerFailureAware(containers[i]);
            }
        }
        return containers;
    }

    private static class TestContainerFailureAware
    implements TestContainer {
        private final TestContainer delegate;

        private TestContainerFailureAware(TestContainer delegate) {
            this.delegate = delegate;
        }

        public TestContainer start() {
            try {
                return this.delegate.start();
            }
            catch (RuntimeException e) {
                Utils.dumpFile(TestContainerFailureAware.getKarafLogFile(), System.err);
                throw e;
            }
        }

        public long install(InputStream stream) {
            return this.delegate.install(stream);
        }

        public long install(String location, InputStream stream) {
            return this.delegate.install(location, stream);
        }

        public long installProbe(InputStream stream) {
            return this.delegate.installProbe(stream);
        }

        public void uninstallProbe() {
            this.delegate.uninstallProbe();
        }

        public void call(TestAddress address) {
            this.delegate.call(address);
        }

        public TestContainer stop() {
            return this.delegate.stop();
        }

        private static File getKarafUnpackDirectory() {
            return new File(PathUtils.getBaseDir(), "target/exam");
        }

        private static File getKarafLogFile() {
            return new File(TestContainerFailureAware.searchKarafBase(TestContainerFailureAware.getKarafUnpackDirectory()), "data/log/karaf.log");
        }

        private static File searchKarafBase(File root) {
            LinkedList<File> searchNext = new LinkedList<File>();
            searchNext.add(root);
            while (!searchNext.isEmpty()) {
                File head = (File)searchNext.poll();
                if (!head.isDirectory()) continue;
                if (new File(head, "system").isDirectory() && new File(head, "etc").isDirectory()) {
                    return head;
                }
                searchNext.addAll(List.of(Objects.requireNonNull(head.listFiles())));
            }
            return null;
        }
    }
}

