/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.IntPredicate;
import java.util.stream.Stream;
import org.apache.karaf.camel.itests.CamelKarafTestHint;
import org.jetbrains.annotations.NotNull;
import org.ops4j.pax.exam.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    static String toKebabCase(String name) {
        return name.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase();
    }

    public static int getAvailablePort(int min, int max) {
        return Utils.getAvailablePort(min, max, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort(int min, int max, IntPredicate filter) {
        int port = min;
        while (port <= max) {
            try (ServerSocket socket = new ServerSocket();){
                socket.setReuseAddress(true);
                socket.bind(new InetSocketAddress(InetAddress.getByName("localhost"), port), 1);
                if (filter == null || filter.test(port)) {
                    int n = socket.getLocalPort();
                    return n;
                }
            }
            catch (Exception e) {
                LOG.debug("Port {} not available, trying next one", (Object)port);
            }
            ++port;
        }
        throw new IllegalStateException("Can't find available network ports");
    }

    public static int getNextAvailablePort() {
        return Utils.getNextAvailablePort(null);
    }

    public static int getNextAvailablePort(IntPredicate filter) {
        return Utils.getAvailablePort(30000, 40000, filter);
    }

    public static String getCamelContextName(Class<?> clazz) {
        CamelKarafTestHint hint = clazz.getAnnotation(CamelKarafTestHint.class);
        if (hint == null || hint.camelContextName().isEmpty()) {
            return null;
        }
        return hint.camelContextName();
    }

    static String loadCamelKarafVersion() {
        try {
            String version = MavenUtils.asInProject().getVersion("org.apache.camel.karaf", "camel-integration-test");
            LOG.info("Detected Camel Karaf version: {}", (Object)version);
            return version;
        }
        catch (Exception e) {
            LOG.debug("Can't detect Camel Karaf version", (Throwable)e);
            return null;
        }
    }

    static String loadUsersFileIfAbsent(String baseDir) {
        Path location = Paths.get(baseDir, "camel-karaf-itest-resources", "users.properties");
        if (Files.exists(location, new LinkOption[0])) {
            LOG.debug("Detected users file at {}", (Object)location);
            return location.toString();
        }
        return Utils.loadUsersFile(location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String loadUsersFile(Path location) {
        try (InputStream is = Utils.class.getResourceAsStream("/etc/users.properties");){
            if (is == null) throw new IllegalStateException("Can't find the users.properties file, please provide it using the system property users.file.location");
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(location, new OpenOption[0]);){
                is.transferTo(os);
            }
            String string = location.toString();
            return string;
        }
        catch (Exception e) {
            LOG.debug("Can't load the users.properties file", (Throwable)e);
        }
        throw new IllegalStateException("Can't find the users.properties file, please provide it using the system property users.file.location");
    }

    static void dumpFile(File file, PrintStream out) {
        if (file.exists()) {
            out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            out.printf(">>>>> START Dumping file %s%n", file.getName());
            out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            try (Stream<String> lines = Files.lines(file.toPath());){
                lines.forEach(out::println);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            out.printf("<<<<< END Dumping file %s%n", file.getName());
            out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }
}

