/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.FunctionCall;
import net.thisptr.jackson.jq.path.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JqFunctions {
    public static final ThreadLocal<Exchange> EXCHANGE_LOCAL = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(JqFunctions.class);

    private JqFunctions() {
    }

    public static void load(CamelContext camelContext, Scope scope) {
        Map fromServiceLoader = BuiltinFunctionLoader.getInstance().loadFunctionsFromServiceLoader(camelContext.getApplicationContextClassLoader() != null ? camelContext.getApplicationContextClassLoader() : BuiltinFunctionLoader.class.getClassLoader(), Versions.JQ_1_6);
        Map fromJq = BuiltinFunctionLoader.getInstance().loadFunctionsFromJsonJq(camelContext.getApplicationContextClassLoader() != null ? camelContext.getApplicationContextClassLoader() : BuiltinFunctionLoader.class.getClassLoader(), Versions.JQ_1_6, scope);
        if (fromServiceLoader != null) {
            LOGGER.debug("Loading {} jq functions from ServiceLoader", (Object)fromServiceLoader.size());
            fromServiceLoader.forEach((arg_0, arg_1) -> ((Scope)scope).addFunction(arg_0, arg_1));
        }
        if (fromJq != null) {
            LOGGER.debug("Loading {} jq functions from Json JQ", (Object)fromJq.size());
            fromJq.forEach((arg_0, arg_1) -> ((Scope)scope).addFunction(arg_0, arg_1));
        }
    }

    public static void loadFromRegistry(CamelContext camelContext, Scope scope) {
        Map fromRegistry = camelContext.getRegistry().findByTypeWithName(Function.class);
        if (fromRegistry != null) {
            LOGGER.debug("Loading {} jq functions from Registry", (Object)fromRegistry.size());
            fromRegistry.forEach((arg_0, arg_1) -> ((Scope)scope).addFunction(arg_0, arg_1));
        }
    }

    public static void loadLocal(Scope scope) {
        scope.addFunction("header", 1, (Function)new Header());
        scope.addFunction("header", 2, (Function)new Header());
        scope.addFunction("property", 1, (Function)new Property());
        scope.addFunction("property", 2, (Function)new Property());
        scope.addFunction("constant", 1, (Function)new Constant());
        scope.addFunction("constant", 2, (Function)new Constant());
    }

    public static class Header
    extends ExchangeAwareFunction {
        public static final String NAME = "header";

        @Override
        protected void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version, Exchange exchange) throws JsonQueryException {
            args.get(0).apply(scope, in, name -> {
                if (args.size() == 2) {
                    ((Expression)args.get(1)).apply(scope, in, defval -> this.extract(exchange, name.asText(), defval.asText(), output));
                } else {
                    this.extract(exchange, name.asText(), null, output);
                }
            });
        }

        private void extract(Exchange exchange, String headerName, String headerValue, PathOutput output) throws JsonQueryException {
            String header = (String)exchange.getMessage().getHeader(headerName, (Object)headerValue, String.class);
            if (header == null) {
                output.emit((JsonNode)NullNode.getInstance(), null);
            } else {
                output.emit((JsonNode)new TextNode(header), null);
            }
        }
    }

    public static class Property
    extends ExchangeAwareFunction {
        public static final String NAME = "property";

        @Override
        protected void doApply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version, Exchange exchange) throws JsonQueryException {
            args.get(0).apply(scope, in, name -> {
                if (args.size() == 2) {
                    ((Expression)args.get(1)).apply(scope, in, defval -> this.extract(exchange, name.asText(), defval.asText(), output));
                } else {
                    this.extract(exchange, name.asText(), null, output);
                }
            });
        }

        private void extract(Exchange exchange, String propertyName, String propertyValue, PathOutput output) throws JsonQueryException {
            String header = (String)exchange.getProperty(propertyName, (Object)propertyValue, String.class);
            if (header == null) {
                output.emit((JsonNode)NullNode.getInstance(), null);
            } else {
                output.emit((JsonNode)new TextNode(header), null);
            }
        }
    }

    public static class Constant
    implements Function {
        public static final String NAME = "constant";

        public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
            FunctionCall fc = (FunctionCall)args.get(0);
            String t = fc.toString();
            output.emit((JsonNode)new TextNode(t), null);
        }
    }

    public static abstract class ExchangeAwareFunction
    implements Function {
        public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
            Exchange exchange = EXCHANGE_LOCAL.get();
            if (exchange != null) {
                this.doApply(scope, args, in, path, output, version, exchange);
            }
        }

        protected abstract void doApply(Scope var1, List<Expression> var2, JsonNode var3, Path var4, PathOutput var5, Version var6, Exchange var7) throws JsonQueryException;
    }
}

