/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath.easypredicate;

import java.util.Arrays;
import java.util.Objects;

public final class EasyPredicateOperators {
    private static final String EQ = "==";
    private static final String NE = "!=";
    private static final String LT = "<";
    private static final String LE = "<=";
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String REG = "=~";
    private static final String IN = "in";
    private static final String NIN = "nin";
    private static final String SIZE = "size";
    private static final String EMPTY = "empty";
    private static final String[] OPS = new String[]{"==", "!=", "<", "<=", ">", ">=", "=~", "in", "nin", "size", "empty"};

    private EasyPredicateOperators() {
    }

    static boolean hasOperator(String exp) {
        return Arrays.stream(OPS).anyMatch(o -> exp.contains(" " + o));
    }

    static boolean isOperator(String exp) {
        return Arrays.stream(OPS).anyMatch(s -> Objects.equals(s, exp));
    }

    static String getOperatorAtStart(String exp) {
        return Arrays.stream(OPS).filter(o -> exp.startsWith(" " + o)).findFirst().orElse(null);
    }
}

