/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.camel.CamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.util.URISupport;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="rest-registry-list", description="Lists all Camel REST services enlisted in the Rest Registry from a Camel context")
@Service
public class RestRegistryList
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The Camel context name where to look for the REST services", required=true, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;
    @Option(name="--decode", aliases={"-d"}, description="Whether to decode the endpoint uri so it's human readable", required=false, multiValued=false, valueToShowInHelp="true")
    boolean decode = true;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Url");
        table.column("Base Path");
        table.column("Uri Template");
        table.column("Method");
        table.column("State");
        CamelContext camelContext = this.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found");
            return null;
        }
        ArrayList services = new ArrayList(camelContext.getRestRegistry().listAllRestServices());
        Collections.sort(services, new Comparator<RestRegistry.RestService>(){

            @Override
            public int compare(RestRegistry.RestService s1, RestRegistry.RestService s2) {
                return s1.getUrl().compareTo(s2.getUrl());
            }
        });
        for (RestRegistry.RestService service : services) {
            String uri = service.getUrl();
            if (this.decode) {
                uri = URLDecoder.decode(uri, "UTF-8");
            }
            uri = URISupport.sanitizeUri((String)uri);
            table.addRow().addContent(new Object[]{uri, service.getBasePath(), service.getUriTemplate(), service.getMethod(), service.getState()});
        }
        table.print(System.out);
        return null;
    }
}

