/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="camel", name="route-list", description="List Camel routes")
@Service
public class RouteList
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The Camel context name where to look for the route", required=false, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String name;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Context");
        table.column("Route");
        table.column("Status");
        table.column("Total #");
        table.column("Failed #");
        table.column("Inflight #");
        table.column("Uptime");
        CamelContext camelContext = this.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found");
            return null;
        }
        for (Route route : camelContext.getRoutes()) {
            ManagedCamelContext mcc = (ManagedCamelContext)camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
            long exchangesTotal = 0L;
            long exchangesInflight = 0L;
            long exchangesFailed = 0L;
            if (mcc != null && mcc.getManagedCamelContext() != null) {
                ManagedRouteMBean mr = mcc.getManagedRoute(route.getId());
                exchangesFailed = mr.getExchangesFailed();
                exchangesInflight = mr.getExchangesInflight();
                exchangesTotal = mr.getExchangesTotal();
            }
            table.addRow().addContent(new Object[]{route.getCamelContext().getName(), route.getId(), this.getRouteState(route), exchangesTotal, exchangesFailed, exchangesInflight, route.getUptime()});
        }
        table.print(System.out);
        return null;
    }

    private String getRouteState(Route route) {
        ServiceStatus status = route.getCamelContext().getRouteController().getRouteStatus(route.getId());
        if (status != null) {
            return status.name();
        }
        return ServiceStatus.Starting.name();
    }
}

