/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import org.apache.camel.CamelContext;
import org.apache.camel.karaf.shell.CamelCommandSupport;
import org.apache.camel.karaf.shell.completers.CamelContextCompleter;
import org.apache.camel.karaf.shell.completers.RouteCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="camel", name="route-resume", description="Resume a Camel route")
@Service
public class RouteResume
extends CamelCommandSupport
implements Action {
    @Argument(index=0, name="context", description="The Camel context name", required=true, multiValued=false)
    @Completion(value=CamelContextCompleter.class)
    String context;
    @Argument(index=1, name="route", description="The Camel route ID or a wildcard expression", required=true, multiValued=false)
    @Completion(value=RouteCompleter.class)
    String route;

    public Object execute() throws Exception {
        CamelContext camelContext = this.getCamelContext(this.context);
        if (camelContext == null) {
            System.err.println("Camel context " + this.context + " not found");
            return null;
        }
        camelContext.getRouteController().resumeRoute(this.route);
        return null;
    }
}

