/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.shell;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CamelCommandSupport.class);
    @Reference
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<CamelContext> getCamelContexts() {
        ArrayList<CamelContext> camelContexts = new ArrayList<CamelContext>();
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(CamelContext.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    CamelContext camelContext;
                    if (reference == null || (camelContext = (CamelContext)this.bundleContext.getService(reference)) == null) continue;
                    camelContexts.add(camelContext);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot retrieve the list of Camel contexts.", (Throwable)e);
        }
        camelContexts.sort(Comparator.comparing(CamelContext::getName));
        return camelContexts;
    }

    public CamelContext getCamelContext(String name) throws Exception {
        for (CamelContext camelContext : this.getCamelContexts()) {
            if (!camelContext.getName().equals(name)) continue;
            return camelContext;
        }
        return null;
    }
}

