/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThreadsMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ThreadsProcessor;

@ManagedResource(description="Managed Threads")
public class ManagedThreads
extends ManagedProcessor
implements ManagedThreadsMBean {
    private final ThreadsProcessor processor;

    public ManagedThreads(CamelContext context, ThreadsProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    public Boolean isCallerRunsWhenRejected() {
        if (this.processor.getExecutorService() instanceof ThreadPoolExecutor) {
            String name = this.getRejectedPolicy();
            return "CallerRuns".equals(name);
        }
        return null;
    }

    public String getRejectedPolicy() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getRejectedExecutionHandler().toString();
        }
        return null;
    }

    public int getCorePoolSize() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getCorePoolSize();
        }
        return 0;
    }

    public int getPoolSize() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getPoolSize();
        }
        return 0;
    }

    public int getMaximumPoolSize() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getMaximumPoolSize();
        }
        return 0;
    }

    public int getLargestPoolSize() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getLargestPoolSize();
        }
        return 0;
    }

    public int getActiveCount() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getActiveCount();
        }
        return 0;
    }

    public long getTaskCount() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getTaskCount();
        }
        return 0L;
    }

    public long getCompletedTaskCount() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getCompletedTaskCount();
        }
        return 0L;
    }

    public long getTaskQueueSize() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
            return queue != null ? (long)queue.size() : 0L;
        }
        return 0L;
    }

    public long getKeepAliveTime() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
        }
        return 0L;
    }

    public boolean isAllowCoreThreadTimeout() {
        ExecutorService executorService = this.processor.getExecutorService();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.allowsCoreThreadTimeOut();
        }
        return false;
    }
}

