/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.component.micrometer.routepolicy.ContextMetricsStatistics;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyConfiguration;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.RouteMetric;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.service.ServiceSupport;

public class MicrometerRoutePolicyFactory
extends ServiceSupport
implements RoutePolicyFactory,
CamelContextAware,
NonManagedService,
StaticService {
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private RouteMetric contextMetric;
    private boolean prettyPrint = true;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerRoutePolicyNamingStrategy namingStrategy = MicrometerRoutePolicyNamingStrategy.DEFAULT;
    private MicrometerRoutePolicyConfiguration policyConfiguration = MicrometerRoutePolicyConfiguration.DEFAULT;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerRoutePolicyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRoutePolicyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public MicrometerRoutePolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public void setPolicyConfiguration(MicrometerRoutePolicyConfiguration policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }

    public RouteMetric createOrGetContextMetric(MicrometerRoutePolicy policy) {
        if (this.contextMetric == null) {
            this.contextMetric = new ContextMetricsStatistics(policy.getMeterRegistry(), this.camelContext, policy.getNamingStrategy(), policy.getConfiguration(), policy.isRegisterKamelets(), policy.isRegisterTemplates());
        }
        return this.contextMetric;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode routeDefinition) {
        MicrometerRoutePolicy answer = new MicrometerRoutePolicy(this);
        answer.setMeterRegistry(this.getMeterRegistry());
        answer.setPrettyPrint(this.isPrettyPrint());
        answer.setDurationUnit(this.getDurationUnit());
        answer.setNamingStrategy(this.getNamingStrategy());
        answer.setConfiguration(this.getPolicyConfiguration());
        return answer;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.contextMetric != null) {
            this.contextMetric.remove();
            this.contextMetric = null;
        }
    }
}

