/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import java.io.InputStream;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mongodb.gridfs.GridFsEndpoint;
import org.apache.camel.component.mongodb.gridfs.QueryStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.bson.Document;
import org.bson.conversions.Bson;

public class GridFsConsumer
extends DefaultConsumer
implements Runnable {
    private final GridFsEndpoint endpoint;
    private volatile ExecutorService executor;

    public GridFsConsumer(GridFsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        this.executor.execute(this);
    }

    @Override
    public void run() {
        Date fromDate = null;
        QueryStrategy queryStrategy = this.endpoint.getQueryStrategy();
        boolean usesTimestamp = queryStrategy != QueryStrategy.FileAttribute;
        boolean persistsTimestamp = queryStrategy == QueryStrategy.PersistentTimestamp || queryStrategy == QueryStrategy.PersistentTimestampAndFileAttribute;
        boolean usesAttribute = queryStrategy == QueryStrategy.FileAttribute || queryStrategy == QueryStrategy.TimeStampAndFileAttribute || queryStrategy == QueryStrategy.PersistentTimestampAndFileAttribute;
        MongoCollection ptsCollection = null;
        Document persistentTimestamp = null;
        if (persistsTimestamp) {
            ptsCollection = this.endpoint.getDB().getCollection(this.endpoint.getPersistentTSCollection());
            if (ptsCollection.countDocuments() < 1000L) {
                ptsCollection.createIndex((Bson)new BasicDBObject("id", (Object)1));
            }
            if ((persistentTimestamp = (Document)ptsCollection.find(Filters.eq((String)"id", (Object)this.endpoint.getPersistentTSObject())).first()) == null) {
                persistentTimestamp = new Document("id", (Object)this.endpoint.getPersistentTSObject());
                fromDate = new Date();
                persistentTimestamp.put("timestamp", (Object)fromDate);
                ptsCollection.insertOne((Object)persistentTimestamp);
            }
            fromDate = (Date)persistentTimestamp.get((Object)"timestamp", Date.class);
        } else if (usesTimestamp) {
            fromDate = new Date();
        }
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(-1).withInterval(Duration.ofMillis(this.endpoint.getDelay())).withInitialDelay(Duration.ofMillis(this.endpoint.getInitialDelay())).build()).build();
        MongoCollection finalPtsCollection = ptsCollection;
        Date finalFromDate = fromDate;
        Document finalPersistentTimestamp = persistentTimestamp;
        task.run(() -> this.processCollection(finalFromDate, usesTimestamp, persistsTimestamp, usesAttribute, (MongoCollection<Document>)finalPtsCollection, finalPersistentTimestamp));
    }

    private boolean processCollection(Date fromDate, boolean usesTimestamp, boolean persistsTimestamp, boolean usesAttribute, MongoCollection<Document> ptsCollection, Document persistentTimestamp) {
        if (!this.isStarted()) {
            return false;
        }
        try (MongoCursor<GridFSFile> cursor = this.getGridFSFileMongoCursor(fromDate, usesTimestamp, usesAttribute);){
            boolean dateModified = false;
            while (cursor.hasNext() && this.isStarted()) {
                GridFSFile file;
                GridFSFile fOrig = file = (GridFSFile)cursor.next();
                if (usesAttribute) {
                    FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
                    options.returnDocument(ReturnDocument.AFTER);
                    Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)file.getId()), Filters.eq((String)this.endpoint.getFileAttributeName(), null)});
                    Bson update = Updates.set((String)this.endpoint.getFileAttributeName(), (Object)"processing");
                    fOrig = (GridFSFile)this.endpoint.getFilesCollection().findOneAndUpdate(filter, update, options);
                }
                if (fOrig == null) continue;
                Exchange exchange = this.createExchange(true);
                GridFSDownloadStream downloadStream = this.endpoint.getGridFsBucket().openDownloadStream(file.getFilename());
                file = downloadStream.getGridFSFile();
                Document metadata = file.getMetadata();
                if (metadata != null) {
                    String contentType = (String)metadata.get((Object)"contentType", String.class);
                    if (contentType != null) {
                        exchange.getIn().setHeader("CamelFileContentType", (Object)contentType);
                    }
                    exchange.getIn().setHeader("gridfs.metadata", (Object)metadata.toJson());
                }
                exchange.getIn().setHeader("CamelFileLength", (Object)file.getLength());
                exchange.getIn().setHeader("CamelFileLastModified", (Object)file.getUploadDate());
                exchange.getIn().setBody((Object)downloadStream, InputStream.class);
                try {
                    this.getProcessor().process(exchange);
                    if (usesAttribute) {
                        Bson update = Updates.set((String)this.endpoint.getFileAttributeName(), (Object)"done");
                        this.endpoint.getFilesCollection().findOneAndUpdate(Filters.eq((String)"_id", (Object)fOrig.getId()), update);
                    }
                    if (!usesTimestamp || file.getUploadDate().compareTo(fromDate) <= 0) continue;
                    fromDate = file.getUploadDate();
                    dateModified = true;
                }
                catch (Exception exception) {}
            }
            if (persistsTimestamp && dateModified) {
                Bson update = Updates.set((String)"timestamp", (Object)fromDate);
                ptsCollection.findOneAndUpdate(Filters.eq((String)"_id", (Object)persistentTimestamp.getObjectId((Object)"_id")), update);
            }
        }
        return false;
    }

    private MongoCursor<GridFSFile> getGridFSFileMongoCursor(Date fromDate, boolean usesTimestamp, boolean usesAttribute) {
        String queryString = this.endpoint.getQuery();
        Bson query = this.getBsonDocument(fromDate, usesTimestamp, usesAttribute, queryString);
        return this.endpoint.getGridFsBucket().find(query).cursor();
    }

    private Bson getBsonDocument(Date fromDate, boolean usesTimestamp, boolean usesAttribute, String queryString) {
        Document query = null;
        if (queryString != null) {
            query = Document.parse((String)queryString);
        }
        if (usesTimestamp) {
            Bson uploadDateFilter = Filters.gt((String)"uploadDate", (Object)fromDate);
            query = query == null ? uploadDateFilter : Filters.and((Bson[])new Bson[]{query, uploadDateFilter});
        }
        if (usesAttribute) {
            Bson fileAttributeNameFilter = Filters.eq((String)this.endpoint.getFileAttributeName(), null);
            query = query == null ? fileAttributeNameFilter : Filters.and((Bson[])new Bson[]{query, fileAttributeNameFilter});
        }
        return query;
    }
}

