/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi.jmx;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.xml.in.ModelParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="jmx-rest-definition-resolver")
public class JmxRestDefinitionsResolver
implements RestDefinitionsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(JmxRestDefinitionsResolver.class);

    @Override
    public List<RestDefinition> getRestDefinitions(CamelContext camelContext, String camelId) throws Exception {
        String xml;
        ObjectName found = null;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> names = server.queryNames(new ObjectName("org.apache.camel:type=context,*"), null);
        for (ObjectName on : names) {
            String id = on.getKeyProperty("name");
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            if (camelId != null && !camelId.equals(id)) continue;
            found = on;
        }
        if (found != null && (xml = (String)server.invoke(found, "dumpRestsAsXml", new Object[]{true}, new String[]{"boolean"})) != null) {
            LOG.debug("DumpRestAsXml:\n{}", (Object)xml);
            Resource resource = PluginHelper.getResourceLoader((CamelContext)camelContext).resolveResource("mem:" + xml);
            RestsDefinition rests = new ModelParser(resource).parseRestsDefinition().orElse(null);
            if (rests != null) {
                return rests.getRests();
            }
        }
        return null;
    }
}

