/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron.processor;

import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.component.schematron.exception.SchematronValidationException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SchematronProcessor {
    private Logger logger = LoggerFactory.getLogger(SchematronProcessor.class);
    private XMLReader reader;
    private Templates templates;

    public SchematronProcessor(XMLReader reader, Templates templates) {
        this.reader = reader;
        this.templates = templates;
    }

    public String validate(String xml) {
        SAXSource source = new SAXSource(this.reader, new InputSource(IOUtils.toInputStream((String)xml, (Charset)Charset.defaultCharset())));
        return this.validate(source);
    }

    public String validate(Source source) {
        try {
            StringWriter writer = new StringWriter();
            this.templates.newTransformer().transform(source, new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            this.logger.error(e.getMessage());
            throw new SchematronValidationException("Failed to apply Schematron validation transform", e);
        }
    }
}

