/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.fuji;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.component.servicenow.releases.fuji.FujiServiceNowProcessor;
import org.apache.camel.util.ObjectHelper;

class FujiServiceNowAggregateProcessor
extends FujiServiceNowProcessor {
    FujiServiceNowAggregateProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, Class<?> requestModel, Class<?> responseModel, String action, String apiVersion, String tableName, String sysId) throws Exception {
        if (!ObjectHelper.equal((Object)"retrieve", (Object)action, (boolean)true)) {
            throw new IllegalArgumentException("Unknown action " + action);
        }
        Response response = this.retrieveStats(exchange.getIn(), responseModel, tableName);
        this.setBodyAndHeaders(exchange.getIn(), responseModel, response);
    }

    private Response retrieveStats(Message in, Class<?> responseModel, String tableName) throws Exception {
        String apiVersion = this.getApiVersion(in);
        return this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("stats").path(tableName).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_AVG_FIELDS, in).query(ServiceNowParams.SYSPARM_COUNT, in).query(ServiceNowParams.SYSPARM_MIN_FIELDS, in).query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_MAX_FIELDS, in).query(ServiceNowParams.SYSPARM_SUM_FIELDS, in).query(ServiceNowParams.SYSPARM_GROUP_BY, in).query(ServiceNowParams.SYSPARM_ORDER_BY, in).query(ServiceNowParams.SYSPARM_HAVING, in).query(ServiceNowParams.SYSPARM_DISPLAY_VALUE, in).query(responseModel).invoke("GET");
    }
}

