/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.xml.ws.RequestWrapper;
import jakarta.xml.ws.ResponseWrapper;
import jakarta.xml.ws.WebFault;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.MethodInfo;
import org.apache.camel.dataformat.soap.name.TypeInfo;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInterfaceStrategy
implements ElementNameStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInterfaceStrategy.class);
    private Map<String, MethodInfo> soapActionToMethodInfo = new HashMap<String, MethodInfo>();
    private Map<String, QName> inTypeNameToQName = new HashMap<String, QName>();
    private Map<String, QName> outTypeNameToQName = new HashMap<String, QName>();
    private boolean isClient;
    private ElementNameStrategy fallBackStrategy;
    private Map<String, Map<QName, Class<? extends Exception>>> faultNameToException = new HashMap<String, Map<QName, Class<? extends Exception>>>();

    public ServiceInterfaceStrategy(Class<?> serviceInterface, boolean isClient) {
        this.analyzeServiceInterface(serviceInterface);
        this.isClient = isClient;
        this.fallBackStrategy = new TypeNameStrategy();
    }

    public String getMethodForSoapAction(String soapAction) {
        MethodInfo methodInfo = this.soapActionToMethodInfo.get(soapAction);
        return methodInfo == null ? null : methodInfo.getName();
    }

    private TypeInfo getOutInfo(Method method) {
        ResponseWrapper respWrap = method.getAnnotation(ResponseWrapper.class);
        if (respWrap != null && respWrap.className() != null) {
            return new TypeInfo(respWrap.className(), new QName(respWrap.targetNamespace(), respWrap.localName()));
        }
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            return new TypeInfo(null, null);
        }
        Class<?> type = method.getReturnType();
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            return new TypeInfo(type.getName(), new QName(webResult.targetNamespace(), webResult.name()));
        }
        throw new IllegalArgumentException("Result type of method " + method.getName() + " is not annotated with WebResult. This is not yet supported");
    }

    private List<TypeInfo> getInInfo(Method method) {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        RequestWrapper requestWrapper = method.getAnnotation(RequestWrapper.class);
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return typeInfos;
        }
        if (requestWrapper != null && requestWrapper.className() != null) {
            typeInfos.add(new TypeInfo(requestWrapper.className(), new QName(requestWrapper.targetNamespace(), requestWrapper.localName())));
            return typeInfos;
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        ArrayList<WebParam> webParams = new ArrayList<WebParam>();
        Annotation[][] annotationArray = annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] singleParameterAnnotations;
            for (Annotation annotation : singleParameterAnnotations = annotationArray[i]) {
                if (!(annotation instanceof WebParam)) continue;
                webParams.add((WebParam)annotation);
            }
        }
        if (webParams.size() != types.length) {
            throw new IllegalArgumentException("The number of @WebParam annotations for Method " + method.getName() + " does not match the number of parameters. This is not supported.");
        }
        Iterator webParamIter = webParams.iterator();
        int paramCounter = -1;
        while (webParamIter.hasNext()) {
            WebParam webParam = (WebParam)webParamIter.next();
            typeInfos.add(new TypeInfo(types[++paramCounter].getName(), new QName(webParam.targetNamespace(), webParam.name())));
        }
        return typeInfos;
    }

    private MethodInfo analyzeMethod(Method method) {
        List<TypeInfo> inInfos = this.getInInfo(method);
        TypeInfo outInfo = this.getOutInfo(method);
        WebMethod webMethod = method.getAnnotation(WebMethod.class);
        String soapAction = webMethod != null ? webMethod.action() : null;
        return new MethodInfo(method.getName(), soapAction, inInfos.toArray(new TypeInfo[0]), outInfo);
    }

    private void analyzeServiceInterface(Class<?> serviceInterface) {
        Method[] methods;
        for (Method method : methods = serviceInterface.getMethods()) {
            MethodInfo info = this.analyzeMethod(method);
            for (int i = 0; i < info.getIn().length; ++i) {
                TypeInfo ti = info.getIn()[i];
                if (this.inTypeNameToQName.containsKey(ti.getTypeName()) && ti.getTypeName() != null && !ti.getTypeName().equals("jakarta.xml.ws.Holder") && !this.inTypeNameToQName.get(ti.getTypeName()).equals(ti.getElName())) {
                    LOG.warn("Ambiguous QName mapping. The type [{}] is already mapped to a QName in this context.", (Object)ti.getTypeName());
                    continue;
                }
                this.inTypeNameToQName.put(ti.getTypeName(), ti.getElName());
            }
            String soapAction = info.getSoapAction();
            if (soapAction != null && !soapAction.isEmpty()) {
                this.soapActionToMethodInfo.put(soapAction, info);
                this.addExceptions(soapAction, method);
            } else {
                this.addExceptions(null, method);
            }
            this.outTypeNameToQName.put(info.getOut().getTypeName(), info.getOut().getElName());
        }
    }

    private void addExceptions(String soapAction, Method method) {
        Class<?>[] exTypes;
        for (Class<?> exType : exTypes = method.getExceptionTypes()) {
            WebFault webFault = exType.getAnnotation(WebFault.class);
            if (webFault == null) continue;
            QName faultName = new QName(webFault.targetNamespace(), webFault.name());
            this.faultNameToException.putIfAbsent(soapAction, new HashMap());
            Map<QName, Class<? extends Exception>> soapActionFaultNameMap = this.faultNameToException.get(soapAction);
            soapActionFaultNameMap.put(faultName, exType);
        }
    }

    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        MethodInfo info = this.soapActionToMethodInfo.get(soapAction);
        if (info != null) {
            if (this.isClient) {
                if (type != null) {
                    return info.getIn(type.getName()).getElName();
                }
                return null;
            }
            return info.getOut().getElName();
        }
        QName qName = null;
        if (type != null) {
            qName = this.isClient ? this.inTypeNameToQName.get(type.getName()) : this.outTypeNameToQName.get(type.getName());
        }
        if (qName == null) {
            try {
                qName = this.fallBackStrategy.findQNameForSoapActionOrType(soapAction, type);
            }
            catch (Exception e) {
                String msg = "No method found that matches the given SoapAction " + soapAction + " or that has an " + (this.isClient ? "input" : "output") + " of type " + type.getName();
                throw new RuntimeCamelException(msg, (Throwable)e);
            }
        }
        return qName;
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        for (Map<QName, Class<? extends Exception>> perSoapActionFaultNameToException : this.faultNameToException.values()) {
            if (perSoapActionFaultNameToException.get(faultName) == null) continue;
            return perSoapActionFaultNameToException.get(faultName);
        }
        return null;
    }

    @Override
    public Class<? extends Exception> findExceptionForSoapActionAndFaultName(String soapAction, QName faultName) {
        if (soapAction == null || soapAction.isEmpty()) {
            return this.findExceptionForFaultName(faultName);
        }
        Map<QName, Class<? extends Exception>> perSoapActionFaultNameToException = this.faultNameToException.get(soapAction);
        if (perSoapActionFaultNameToException == null) {
            return null;
        }
        return perSoapActionFaultNameToException.get(faultName);
    }
}

