/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

public class SolrClientHandlerHttp
extends SolrClientHandler {
    public SolrClientHandlerHttp(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        HttpSolrClient.Builder builder = new HttpSolrClient.Builder(this.getFirstUrlFromList());
        if (!ObjectHelper.isEmpty((Object)this.solrConfiguration.getConnectionTimeout())) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout().intValue());
        }
        if (!ObjectHelper.isEmpty((Object)this.solrConfiguration.getSoTimeout())) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout().intValue());
        }
        if (!ObjectHelper.isEmpty((Object)this.solrConfiguration.getHttpClient())) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        if (!ObjectHelper.isEmpty((Object)this.solrConfiguration.getAllowCompression())) {
            builder.allowCompression(this.solrConfiguration.getAllowCompression().booleanValue());
        }
        if (!ObjectHelper.isEmpty((Object)this.solrConfiguration.getFollowRedirects())) {
            builder.withFollowRedirects(this.solrConfiguration.getFollowRedirects().booleanValue());
        }
        HttpSolrClient httpSolrClient = builder.build();
        return httpSolrClient;
    }
}

