/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;

public class RedisClient {
    private final RedisTemplate<String, Object> redisTemplate;

    public RedisClient(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void hmset(String key, Map<String, Object> param) {
        this.redisTemplate.opsForHash().putAll((Object)key, param);
    }

    public Collection<Object> hmget(String key, Collection<String> fields) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, fields);
    }

    public Set<String> hkeys(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public Long hlen(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public Long hincrBy(String key, String field, Long value) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)field, value.longValue());
    }

    public Map<String, Object> hgetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public Boolean hexists(String key, String field) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)field);
    }

    public Object hget(String key, String field) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)field);
    }

    public void hdel(String key, String field) {
        this.redisTemplate.opsForHash().delete((Object)key, new Object[]{field});
    }

    public void hset(String key, String field, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)field, value);
    }

    public void quit() {
        this.redisTemplate.execute(connection -> {
            connection.close();
            return null;
        });
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public Collection<Object> hvals(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    public Boolean hsetnx(String key, String field, Object value) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)key, (Object)field, value);
    }

    public Long decr(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key, -1L);
    }

    public Long decrby(String key, Long value) {
        return this.redisTemplate.opsForValue().increment((Object)key, -value.longValue());
    }

    public Long incr(String key) {
        return this.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    public Long incrby(String key, Long value) {
        return this.redisTemplate.opsForValue().increment((Object)key, value.longValue());
    }

    public String getrange(String key, Long start, Long end) {
        return this.redisTemplate.opsForValue().get((Object)key, start.longValue(), end.longValue());
    }

    public Long strlen(String key) {
        return this.redisTemplate.opsForValue().size((Object)key);
    }

    public List<Object> mget(Collection<String> fields) {
        return this.redisTemplate.opsForValue().multiGet(fields);
    }

    public void mset(Map<String, Object> map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void msetnx(Map<String, Object> map) {
        this.redisTemplate.opsForValue().multiSetIfAbsent(map);
    }

    public Object getset(String key, Object value) {
        return this.redisTemplate.opsForValue().getAndSet((Object)key, value);
    }

    public Boolean setnx(String key, Object value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, value);
    }

    public void setex(String key, Object value, Long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), timeUnit);
    }

    public void setex(String key, Object value, Long offset) {
        this.redisTemplate.opsForValue().set((Object)key, value, offset.longValue());
    }

    public void setbit(String key, Long offset, Boolean value) {
        this.redisTemplate.execute(connection -> {
            connection.setBit(key.getBytes(), offset.longValue(), value.booleanValue());
            return null;
        });
    }

    public Boolean getbit(String key, Long offset) {
        return (Boolean)this.redisTemplate.execute(connection -> connection.getBit(key.getBytes(), offset.longValue()));
    }

    public Integer append(String key, String value) {
        return this.redisTemplate.opsForValue().append((Object)key, value);
    }

    public void multi() {
        this.redisTemplate.multi();
    }

    public void unwatch() {
        this.redisTemplate.unwatch();
    }

    public void discard() {
        this.redisTemplate.discard();
    }

    public void exec() {
        this.redisTemplate.exec();
    }

    public void watch(Collection<String> keys) {
        this.redisTemplate.watch(keys);
    }

    public Long sadd(String key, Object value) {
        return this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
    }

    public Long scard(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public Set<Object> sdiff(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().difference((Object)key, keys);
    }

    public void sdiffstore(String key, Collection<String> keys, String destinations) {
        this.redisTemplate.opsForSet().differenceAndStore((Object)key, keys, (Object)destinations);
    }

    public Set<Object> sinter(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().intersect((Object)key, keys);
    }

    public void sinterstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForSet().intersectAndStore((Object)key, keys, (Object)destination);
    }

    public Boolean sismember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Set<Object> smembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Boolean smove(String key, Object value, String destination) {
        return this.redisTemplate.opsForSet().move((Object)key, value, (Object)destination);
    }

    public Object spop(String key) {
        return this.redisTemplate.opsForSet().pop((Object)key);
    }

    public Object srandmember(String key) {
        return this.redisTemplate.opsForSet().randomMember((Object)key);
    }

    public Long srem(String key, Object value) {
        return this.redisTemplate.opsForSet().remove((Object)key, new Object[]{value});
    }

    public Set<Object> sunion(String key, Collection<String> keys) {
        return this.redisTemplate.opsForSet().union((Object)key, keys);
    }

    public void sunionstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForSet().unionAndStore((Object)key, keys, (Object)destination);
    }

    public String echo(String value) {
        return (String)this.redisTemplate.execute(connection -> new String(connection.echo(value.getBytes())));
    }

    public String ping() {
        return (String)this.redisTemplate.execute(connection -> connection.ping());
    }

    public void publish(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    public Object lpop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Object blpop(String key, Long timeout) {
        return this.redisTemplate.opsForList().leftPop((Object)key, timeout.longValue(), TimeUnit.SECONDS);
    }

    public Object brpoplpush(String key, String destination, Long timeout) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush((Object)key, (Object)destination, timeout.longValue(), TimeUnit.SECONDS);
    }

    public Object rpoplpush(String key, String destination) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush((Object)key, (Object)destination);
    }

    public Object lindex(String key, Long index) {
        return this.redisTemplate.opsForList().index((Object)key, index.longValue());
    }

    public Long linsert(String key, Object value, String pivot, String position) {
        if ("BEFORE".equals(position)) {
            return this.redisTemplate.opsForList().leftPush((Object)key, (Object)pivot, value);
        }
        if ("AFTER".equals(position)) {
            return this.redisTemplate.opsForList().rightPush((Object)key, (Object)pivot, value);
        }
        throw new IllegalArgumentException("Wrong position: " + position);
    }

    public Object rpop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public Object brpop(String key, Long timeout) {
        return this.redisTemplate.opsForList().rightPop((Object)key, timeout.longValue(), TimeUnit.SECONDS);
    }

    public Long llen(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public List<Object> lrange(String key, Long start, Long end) {
        return this.redisTemplate.opsForList().range((Object)key, start.longValue(), end.longValue());
    }

    public Long lrem(String key, Object value, Long count) {
        return this.redisTemplate.opsForList().remove((Object)key, count.longValue(), value);
    }

    public void lset(String key, Object value, Long index) {
        this.redisTemplate.opsForList().set((Object)key, index.longValue(), value);
    }

    public void ltrim(String key, Long start, Long end) {
        this.redisTemplate.opsForList().trim((Object)key, start.longValue(), end.longValue());
    }

    public Long rpush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public Long rpushx(String key, Object value) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)key, value);
    }

    public Long lpush(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public Long lpushx(String key, Object value) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)key, value);
    }

    public void del(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public Boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean expire(String key, Long timeout) {
        return this.redisTemplate.expire((Object)key, timeout.longValue(), TimeUnit.SECONDS);
    }

    public Boolean expireat(String key, Long seconds) {
        return this.redisTemplate.expireAt((Object)key, new Date(seconds * 1000L));
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean move(String key, Integer db) {
        return this.redisTemplate.move((Object)key, db.intValue());
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public Boolean pexpire(String key, Long timeout) {
        return this.redisTemplate.expire((Object)key, timeout.longValue(), TimeUnit.MILLISECONDS);
    }

    public Boolean pexpireat(String key, Long millis) {
        return this.redisTemplate.expireAt((Object)key, new Date(millis));
    }

    public String randomkey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String key, String value) {
        this.redisTemplate.rename((Object)key, (Object)value);
    }

    public Boolean renamenx(String key, String value) {
        return this.redisTemplate.renameIfAbsent((Object)key, (Object)value);
    }

    public Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public String type(String key) {
        return this.redisTemplate.type((Object)key).toString();
    }

    public List<Object> sort(String key) {
        SortQuery sortQuery = SortQueryBuilder.sort((Object)key).build();
        return this.redisTemplate.sort(sortQuery);
    }

    public Boolean zadd(String key, Object value, Double score) {
        return this.redisTemplate.opsForZSet().add((Object)key, value, score.doubleValue());
    }

    public Long zcard(String key) {
        return this.redisTemplate.opsForZSet().size((Object)key);
    }

    public Long zcount(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().count((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Double zincrby(String key, Object value, Double increment) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, value, increment.doubleValue());
    }

    public void zinterstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForZSet().intersectAndStore((Object)key, keys, (Object)destination);
    }

    public Object zrange(String key, Long start, Long end, Boolean withScore) {
        if (withScore != null && withScore.booleanValue()) {
            return this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start.longValue(), end.longValue());
        }
        return this.redisTemplate.opsForZSet().range((Object)key, start.longValue(), end.longValue());
    }

    public Set<Object> zrangebyscore(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long zrank(String key, Object value) {
        return this.redisTemplate.opsForZSet().rank((Object)key, value);
    }

    public Long zrem(String key, Object value) {
        return this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{value});
    }

    public void zremrangebyrank(String key, Long start, Long end) {
        this.redisTemplate.opsForZSet().removeRange((Object)key, start.longValue(), end.longValue());
    }

    public void zremrangebyscore(String key, Long start, Long end) {
        this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, (double)start.longValue(), (double)end.longValue());
    }

    public Object zrevrange(String key, Long start, Long end, Boolean withScore) {
        if (withScore != null && withScore.booleanValue()) {
            return this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start.longValue(), end.longValue());
        }
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, start.longValue(), end.longValue());
    }

    public Set<Object> zrevrangebyscore(String key, Double min, Double max) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long zrevrank(String key, Object value) {
        return this.redisTemplate.opsForZSet().reverseRank((Object)key, value);
    }

    public void zunionstore(String key, Collection<String> keys, String destination) {
        this.redisTemplate.opsForZSet().unionAndStore((Object)key, keys, (Object)destination);
    }

    public Long geoadd(String key, double latitude, double longitude, Object member) {
        Point point = new Point(latitude, longitude);
        return this.redisTemplate.opsForGeo().add((Object)key, point, member);
    }

    public Distance geodist(String key, Object member1, Object member2) {
        return this.redisTemplate.opsForGeo().distance((Object)key, member1, member2);
    }

    public List<String> geohash(String key, Object member) {
        return this.redisTemplate.opsForGeo().hash((Object)key, new Object[]{member});
    }

    public List<Point> geopos(String key, Object member) {
        return this.redisTemplate.opsForGeo().position((Object)key, new Object[]{member});
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> georadius(String key, double latitude, double longitude, double radius, Long limit) {
        Point point = new Point(latitude, longitude);
        Circle within = new Circle(point, radius);
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeCoordinates().includeDistance().sortAscending();
        if (limit != null) {
            args.limit(limit.longValue());
        }
        return this.redisTemplate.opsForGeo().radius((Object)key, within, args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> georadius(String key, Object member, double radius, Long limit) {
        Distance distance = new Distance(radius);
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeCoordinates().includeDistance().sortAscending();
        if (limit != null) {
            args.limit(limit.longValue());
        }
        return this.redisTemplate.opsForGeo().radius((Object)key, member, distance, args);
    }
}

