/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultGif
extends InlineQueryResult {
    private static final String TYPE = "gif";
    @JsonProperty(value="gif_url")
    private String gifUrl;
    @JsonProperty(value="gif_width")
    private String gifWidth;
    @JsonProperty(value="gif_height")
    private Integer gifHeight;
    @JsonProperty(value="gif_duration")
    private Integer duration;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    private String title;
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultGif() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGifUrl() {
        return this.gifUrl;
    }

    public String getGifWidth() {
        return this.gifWidth;
    }

    public Integer getGifHeight() {
        return this.gifHeight;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setGifUrl(String gifUrl) {
        this.gifUrl = gifUrl;
    }

    public void setGifWidth(String gifWidth) {
        this.gifWidth = gifWidth;
    }

    public void setGifHeight(Integer gifHeight) {
        this.gifHeight = gifHeight;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String gifUrl;
        private String gifWidth;
        private Integer gifHeight;
        private Integer duration;
        private String thumbUrl;
        private String title;
        private String caption;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder gifUrl(String url) {
            this.gifUrl = url;
            return this;
        }

        public Builder gifWidth(String width) {
            this.gifWidth = width;
            return this;
        }

        public Builder gifHeight(Integer height) {
            this.gifHeight = height;
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultGif build() {
            InlineQueryResultGif inlineQueryResultGif = new InlineQueryResultGif();
            inlineQueryResultGif.setType(InlineQueryResultGif.TYPE);
            inlineQueryResultGif.setId(this.id);
            inlineQueryResultGif.setReplyMarkup(this.replyMarkup);
            inlineQueryResultGif.gifWidth = this.gifWidth;
            inlineQueryResultGif.gifUrl = this.gifUrl;
            inlineQueryResultGif.gifHeight = this.gifHeight;
            inlineQueryResultGif.duration = this.duration;
            inlineQueryResultGif.caption = this.caption;
            inlineQueryResultGif.parseMode = this.parseMode;
            inlineQueryResultGif.thumbUrl = this.thumbUrl;
            inlineQueryResultGif.title = this.title;
            inlineQueryResultGif.inputMessageContext = this.inputMessageContext;
            return inlineQueryResultGif;
        }
    }
}

