/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.ThreadFactoryTypeAware;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelThreadFactory
implements ThreadFactoryTypeAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelThreadFactory.class);
    private static final ThreadFactoryType TYPE = ThreadFactoryType.current();
    private final String pattern;
    private final String name;
    private final boolean daemon;
    private final ThreadFactoryType threadType;

    public CamelThreadFactory(String pattern, String name, boolean daemon) {
        this.pattern = pattern;
        this.name = name;
        this.daemon = daemon;
        this.threadType = daemon ? TYPE : ThreadFactoryType.PLATFORM;
    }

    @Override
    public boolean isVirtual() {
        return this.threadType == ThreadFactoryType.VIRTUAL;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String threadName = ThreadHelper.resolveThreadName(this.pattern, this.name);
        Thread answer = this.threadType.newThread(threadName, this.daemon, runnable);
        LOG.trace("Created thread[{}] -> {}", (Object)threadName, (Object)answer);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CamelThreadFactory[" + this.name + "]";
    }
}

