/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.saxon.XsltSaxonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.EndpointHelper;

@org.apache.camel.spi.annotations.Component(value="xslt-saxon")
public class XsltSaxonComponent
extends XsltComponent {
    @Metadata(label="advanced")
    private Configuration saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @Metadata(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;
    @Metadata(label="advanced", defaultValue="true")
    private boolean secureProcessing = true;

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter((CamelContext)this.getCamelContext(), (String)extensionFunctions, Object.class);
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing;
    }

    public void setSecureProcessing(boolean secureProcessing) {
        this.secureProcessing = secureProcessing;
    }

    public Configuration getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Configuration saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    protected XsltSaxonEndpoint createXsltEndpoint(String uri) {
        return new XsltSaxonEndpoint(uri, (Component)this);
    }

    protected void configureEndpoint(Endpoint endpoint, String remaining, Map<String, Object> parameters) throws Exception {
        XsltSaxonEndpoint saxon = (XsltSaxonEndpoint)endpoint;
        saxon.setContentCache(this.isContentCache());
        saxon.setSaxonConfiguration(this.saxonConfiguration);
        saxon.setSaxonConfigurationProperties(this.saxonConfigurationProperties);
        saxon.setSaxonExtensionFunctions(this.saxonExtensionFunctions);
        saxon.setSecureProcessing(this.secureProcessing);
        super.configureEndpoint(endpoint, remaining, parameters);
    }
}

