/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    public static final String[] SUPPORTED_EXTENSION = new String[]{"yaml", "camel.yaml", "pipe.yaml"};
    private static final Logger LOG = LoggerFactory.getLogger(YamlRoutesBuilderLoader.class);
    @Deprecated
    private static final String PIPE_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1beta2";
    private static final String KNATIVE_MESSAGING_VERSION = "messaging.knative.dev/v1";
    private static final String KNATIVE_EVENTING_VERSION = "eventing.knative.dev/v1";
    private static final String KNATIVE_EVENT_TYPE = "org.apache.camel.event";
    private final Map<String, Boolean> preparseDone = new ConcurrentHashMap<String, Boolean>();

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    YamlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    @Override
    public boolean isSupportedExtension(String extension) {
        return Arrays.asList(SUPPORTED_EXTENSION).contains(extension);
    }

    @Override
    protected RouteBuilder builder(final YamlDeserializationContext ctx, final Node root) {
        final HashSet indexes = new HashSet();
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                YamlDeserializerSupport.setDeserializationContext(root, ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)target)) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)target);
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfigure(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfigure(target);
                }
                Resource resource = ctx.getResource();
                if (resource != null) {
                    YamlRoutesBuilderLoader.this.preparseDone.remove(resource.getLocation());
                }
                YamlRoutesBuilderLoader.this.beansDeserializer.clearCache();
            }

            private boolean doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route(route);
                    return true;
                }
                if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                    return true;
                }
                if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                    return true;
                }
                if (item instanceof InterceptFromDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getInterceptFroms().add((InterceptFromDefinition)item);
                    return true;
                }
                if (item instanceof InterceptDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getIntercepts().add((InterceptDefinition)item);
                    return true;
                }
                if (item instanceof InterceptSendToEndpointDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getInterceptSendTos().add((InterceptSendToEndpointDefinition)item);
                    return true;
                }
                if (item instanceof OnCompletionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnCompletions().add((OnCompletionDefinition)item);
                    return true;
                }
                if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                    return true;
                }
                if (item instanceof ErrorHandlerFactory) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerFactory)item);
                    return true;
                }
                if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteTemplateCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                    return true;
                }
                if (item instanceof TemplatedRouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getTemplatedRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getTemplatedRouteCollection().templatedRoute((TemplatedRouteDefinition)item);
                    return true;
                }
                if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRestCollection(), (CamelContext)this.getCamelContext());
                    this.getRestCollection().rest(definition);
                    return true;
                }
                if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    return true;
                }
                return false;
            }

            public void configuration() throws Exception {
                YamlDeserializerSupport.setDeserializationContext(root, ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator it = ObjectHelper.createIterator((Object)target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)target)) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)target);
                        for (Node node : seq.getValue()) {
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = ((Mark)node.getStartMark().get()).getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || node.getNodeType() != NodeType.MAPPING) continue;
                            MappingNode mn = YamlDeserializerSupport.asMappingNode(node);
                            for (NodeTuple nt : mn.getValue()) {
                                Object item;
                                boolean accepted;
                                String key = YamlDeserializerSupport.asText(nt.getKeyNode());
                                if (!"route-configuration".equals(key) && !"routeConfiguration".equals(key) || !(accepted = this.doConfiguration(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                                indexes.add(idx);
                            }
                        }
                        continue;
                    }
                    this.doConfiguration(target);
                }
            }

            private boolean doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteConfigurationCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                    return true;
                }
                return false;
            }
        };
    }

    private Object preConfigureNode(Node root, YamlDeserializationContext ctx, boolean preParse) {
        Object target = root;
        if (Objects.equals(root.getNodeType(), NodeType.MAPPING)) {
            boolean pipe;
            MappingNode mn = YamlDeserializerSupport.asMappingNode(root);
            boolean bl = pipe = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(PIPE_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Pipe");
            if (pipe) {
                target = this.preConfigurePipe(root, ctx, target, preParse);
            }
        }
        if (preParse && Objects.equals(root.getNodeType(), NodeType.SEQUENCE)) {
            ArrayList<Object> list = new ArrayList<Object>();
            SequenceNode sn = YamlDeserializerSupport.asSequenceNode(root);
            for (Node node : sn.getValue()) {
                if (!Objects.equals(node.getNodeType(), NodeType.MAPPING)) continue;
                MappingNode mn = YamlDeserializerSupport.asMappingNode(node);
                for (NodeTuple nt : mn.getValue()) {
                    String key = YamlDeserializerSupport.asText(nt.getKeyNode());
                    if (!"beans".equals(key)) continue;
                    Node beans = nt.getValueNode();
                    YamlDeserializerSupport.setDeserializationContext(beans, ctx);
                    Object output = this.beansDeserializer.construct(beans);
                    if (output == null) continue;
                    list.add(output);
                }
            }
            if (!list.isEmpty()) {
                target = list;
            }
        }
        return target;
    }

    private Object preConfigurePipe(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        MappingNode ann = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/metadata/annotations"));
        Map<String, Object> params = YamlDeserializerSupport.asMap((Node)ann);
        if (!preParse) {
            RouteDefinition route = new RouteDefinition();
            String routeId = YamlDeserializerSupport.asText(YamlDeserializerSupport.nodeAt(root, "/metadata/name"));
            if (routeId != null) {
                route.routeId(routeId);
            }
            MappingNode source = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/source"));
            MappingNode sink = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/sink"));
            if (source != null) {
                MappingNode errorHandler;
                Node steps;
                MappingNode dataTypes;
                int line = -1;
                if (source.getStartMark().isPresent()) {
                    line = ((Mark)source.getStartMark().get()).getLine();
                }
                String uri = this.extractCamelEndpointUri(source);
                route.from(uri);
                if (line != -1) {
                    route.getInput().setLineNumber(line);
                    if (ctx != null) {
                        route.getInput().setLocation(ctx.getResource().getLocation());
                    }
                }
                if ((dataTypes = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)source, "/dataTypes"))) != null) {
                    MappingNode out;
                    MappingNode in = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)dataTypes, "/in"));
                    if (in != null) {
                        route.inputType(this.extractDataType(in));
                    }
                    if ((out = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)dataTypes, "/out"))) != null) {
                        route.transform(new DataType(this.extractDataType(out)));
                    }
                }
                if ((steps = YamlDeserializerSupport.nodeAt(root, "/spec/steps")) != null) {
                    SequenceNode sn = YamlDeserializerSupport.asSequenceNode(steps);
                    for (Node node : sn.getValue()) {
                        ToDefinition out;
                        boolean kamelet;
                        MappingNode step = YamlDeserializerSupport.asMappingNode(node);
                        uri = this.extractCamelEndpointUri(step);
                        if (uri == null) continue;
                        line = -1;
                        if (node.getStartMark().isPresent()) {
                            line = ((Mark)node.getStartMark().get()).getLine();
                        }
                        if (kamelet = uri.startsWith("kamelet:")) {
                            uri = uri.substring(8);
                            out = new KameletDefinition(uri);
                        } else {
                            out = new ToDefinition(uri);
                        }
                        route.addOutput((ProcessorDefinition)out);
                        if (line == -1) continue;
                        out.setLineNumber(line);
                        if (ctx == null) continue;
                        out.setLocation(ctx.getResource().getLocation());
                    }
                }
                if (sink != null) {
                    dataTypes = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)sink, "/dataTypes"));
                    if (dataTypes != null) {
                        MappingNode out;
                        MappingNode in = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)dataTypes, "/in"));
                        if (in != null) {
                            route.transform(new DataType(this.extractDataType(in)));
                        }
                        if ((out = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)dataTypes, "/out"))) != null) {
                            route.outputType(this.extractDataType(out));
                        }
                    }
                    line = -1;
                    if (sink.getStartMark().isPresent()) {
                        line = ((Mark)sink.getStartMark().get()).getLine();
                    }
                    uri = this.extractCamelEndpointUri(sink);
                    ToDefinition to = new ToDefinition(uri);
                    route.addOutput((ProcessorDefinition)to);
                    if (line != -1) {
                        to.setLineNumber(line);
                        if (ctx != null) {
                            to.setLocation(ctx.getResource().getLocation());
                        }
                    }
                }
                if ((errorHandler = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/errorHandler"))) != null) {
                    NodeTuple nt = (NodeTuple)errorHandler.getValue().get(0);
                    String ehName = YamlDeserializerSupport.asText(nt.getKeyNode());
                    DefaultErrorHandlerDefinition ehf = null;
                    if ("sink".equals(ehName)) {
                        DeadLetterChannelDefinition dlcd = new DeadLetterChannelDefinition();
                        MappingNode endpoint = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(nt.getValueNode(), "/endpoint"));
                        String dlq = this.extractCamelEndpointUri(endpoint);
                        dlcd.setDeadLetterUri(dlq);
                        ehf = dlcd;
                    } else if ("log".equals(ehName)) {
                        ehf = new DefaultErrorHandlerDefinition();
                    } else if ("none".equals(ehName)) {
                        route.errorHandler((ErrorHandlerFactory)new NoErrorHandlerDefinition());
                    }
                    if (ehf != null) {
                        MappingNode prop = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(nt.getValueNode(), "/parameters"));
                        params = YamlDeserializerSupport.asMap((Node)prop);
                        if (params != null) {
                            PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget((Object)ehf).withProperties(params).bind();
                        }
                        route.errorHandler((ErrorHandlerFactory)ehf);
                    }
                }
            }
            answer.add(route);
        }
        return answer;
    }

    private String extractDataType(MappingNode node) {
        String scheme = this.extractTupleValue(node.getValue(), "scheme");
        String format = this.extractTupleValue(node.getValue(), "format");
        if (scheme != null) {
            return scheme + ":" + format;
        }
        return format;
    }

    private String extractCamelEndpointUri(MappingNode node) {
        boolean knativeChannel;
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt((Node)node, "/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode(ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KafkaTopic");
        boolean knativeBroker = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_EVENTING_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Broker");
        boolean bl = knativeChannel = !kamelet && !strimzi && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_MESSAGING_VERSION));
        Object uri = knativeBroker ? KNATIVE_EVENT_TYPE : (kamelet || strimzi || knativeChannel ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri"));
        MappingNode prop = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt((Node)node, "/properties"));
        Map<String, Object> params = YamlDeserializerSupport.asMap((Node)prop);
        if (knativeBroker && params != null && params.containsKey("type")) {
            uri = params.remove("type").toString();
        }
        if (params != null && !params.isEmpty()) {
            String query = URISupport.createQueryString(params);
            uri = (String)uri + "?" + query;
        }
        if (kamelet) {
            return "kamelet:" + (String)uri;
        }
        if (strimzi) {
            return "kafka:" + (String)uri;
        }
        if (knativeBroker) {
            uri = ((String)uri).contains("?") ? (String)uri + "&kind=Broker&name=" + this.extractTupleValue(mn.getValue(), "name") : (String)uri + "?kind=Broker&name=" + this.extractTupleValue(mn.getValue(), "name");
            return "knative:event/" + (String)uri;
        }
        if (knativeChannel) {
            return "knative:channel/" + (String)uri;
        }
        return uri;
    }

    public void preParseRoute(Resource resource) throws Exception {
        if (this.preparseDone.getOrDefault(resource.getLocation(), false).booleanValue()) {
            return;
        }
        LOG.trace("Pre-parsing: {}", (Object)resource.getLocation());
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = this.resourceInputStream(resource);){
            LoadSettings local = LoadSettings.builder().setLabel(resource.getLocation()).build();
            YamlDeserializationContext ctx = this.newYamlDeserializationContext(local, resource);
            StreamReader reader = new StreamReader(local, (Reader)new YamlUnicodeReader(is));
            ParserImpl parser = new ParserImpl(local, reader);
            Composer composer = new Composer(local, (Parser)parser);
            try {
                composer.getSingleNode().map(node -> this.preParseNode(ctx, (Node)node));
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error pre-parsing resource: " + ctx.getResource().getLocation(), (Throwable)e);
            }
            finally {
                ctx.close();
            }
        }
        this.preparseDone.put(resource.getLocation(), true);
    }

    private Object preParseNode(YamlDeserializationContext ctx, Node root) {
        LOG.trace("Pre-parsing node: {}", (Object)root);
        YamlDeserializerSupport.setDeserializationContext(root, ctx);
        Object target = this.preConfigureNode(root, ctx, true);
        Iterator it = ObjectHelper.createIterator((Object)target);
        while (it.hasNext()) {
            target = it.next();
            if (!(target instanceof CamelContextCustomizer)) continue;
            CamelContextCustomizer customizer = (CamelContextCustomizer)target;
            customizer.configure(this.getCamelContext());
        }
        return null;
    }
}

