/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.BeanModelHelper;
import org.apache.camel.model.Model;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"beans"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.model.BeanFactoryDefinition")})
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    private final Set<String> beanCache = new HashSet<String>();

    public Object construct(Node node) {
        BeansCustomizer answer = new BeansCustomizer();
        SequenceNode sn = BeansDeserializer.asSequenceNode(node);
        YamlDeserializationContext dc = BeansDeserializer.getDeserializationContext(node);
        for (Node item : sn.getValue()) {
            String key;
            boolean duplicate;
            BeansDeserializer.setDeserializationContext(item, dc);
            BeanFactoryDefinition bean = BeansDeserializer.asType(item, BeanFactoryDefinition.class);
            if (dc != null) {
                bean.setResource(dc.getResource());
            }
            ObjectHelper.notNull((Object)bean.getName(), (String)"The bean name must be set");
            ObjectHelper.notNull((Object)bean.getType(), (String)"The bean type must be set");
            if (!bean.getType().startsWith("#class:")) {
                bean.setType("#class:" + bean.getType());
            }
            if (bean.getScriptLanguage() != null || bean.getScript() != null) {
                ObjectHelper.notNull((Object)bean.getScriptLanguage(), (String)"The bean script language must be set");
                ObjectHelper.notNull((Object)bean.getScript(), (String)"The bean script must be set");
            }
            if (duplicate = this.beanCache.contains(key = bean.getName() + ":" + bean.getType())) continue;
            answer.addBean(bean);
            this.beanCache.add(key);
        }
        return answer;
    }

    public void clearCache() {
        this.beanCache.clear();
    }

    protected void registerBean(CamelContext camelContext, List<BeanFactoryDefinition<?>> delayedRegistrations, BeanFactoryDefinition<?> def, boolean delayIfFailed) {
        CamelBeanPostProcessor cbpp = PluginHelper.getBeanPostProcessor((CamelContext)camelContext);
        Predicate lazy = cbpp.getLazyBeanStrategy();
        String name = def.getName();
        String type = def.getType();
        try {
            if (!delayIfFailed && lazy != null && lazy.test(null)) {
                this.bindLazyBean(camelContext, def, name, () -> {
                    try {
                        return BeanModelHelper.newInstance((BeanFactoryDefinition)def, (CamelContext)camelContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            } else {
                Object target = BeanModelHelper.newInstance(def, (CamelContext)camelContext);
                this.bindBean(camelContext, def, name, target);
            }
        }
        catch (Exception e) {
            if (delayIfFailed) {
                delayedRegistrations.add(def);
            }
            String msg = name != null ? "Error creating bean: " + name + " of type: " + type : "Error creating bean: " + type;
            throw new RuntimeException(msg, e);
        }
    }

    protected void bindBean(CamelContext camelContext, BeanFactoryDefinition<?> def, String name, Object target) throws Exception {
        camelContext.getRegistry().unbind(name);
        camelContext.getRegistry().bind(name, target, def.getInitMethod(), def.getDestroyMethod());
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        model.addCustomBean(def);
    }

    protected void bindLazyBean(CamelContext camelContext, BeanFactoryDefinition<?> def, String name, Supplier<Object> target) throws Exception {
        Class beanType = null;
        if (def.getType() != null) {
            beanType = camelContext.getClassResolver().resolveClass(def.getType());
        }
        if (beanType == null) {
            beanType = Object.class;
        }
        camelContext.getRegistry().unbind(name);
        camelContext.getRegistry().bind(name, beanType, target, def.getInitMethod(), def.getDestroyMethod());
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        model.addCustomBean(def);
    }

    private class BeansCustomizer
    implements CamelContextCustomizer {
        private final List<BeanFactoryDefinition<?>> delayedRegistrations = new ArrayList();
        private final List<BeanFactoryDefinition<?>> beans = new ArrayList();

        private BeansCustomizer() {
        }

        public void addBean(BeanFactoryDefinition<?> bean) {
            this.beans.add(bean);
        }

        public void configure(CamelContext camelContext) {
            for (BeanFactoryDefinition<?> bean : this.beans) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, true);
            }
            this.beans.clear();
            for (BeanFactoryDefinition<?> bean : this.delayedRegistrations) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, false);
            }
            this.delayedRegistrations.clear();
        }
    }
}

