/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.model.ErrorHandlerDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InputTypeDefinition;
import org.apache.camel.model.OutputTypeDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(nodes={"route"}, types={RouteDefinition.class}, order=0, properties={@YamlProperty(name="id", type="string"), @YamlProperty(name="description", type="string"), @YamlProperty(name="group", type="string"), @YamlProperty(name="nodePrefixId", type="string"), @YamlProperty(name="precondition", type="string"), @YamlProperty(name="routeConfigurationId", type="string"), @YamlProperty(name="autoStartup", type="boolean"), @YamlProperty(name="routePolicy", type="string"), @YamlProperty(name="startupOrder", type="number"), @YamlProperty(name="streamCache", type="boolean"), @YamlProperty(name="messageHistory", type="boolean"), @YamlProperty(name="logMask", type="boolean"), @YamlProperty(name="trace", type="boolean"), @YamlProperty(name="errorHandlerRef", type="string"), @YamlProperty(name="errorHandler", type="object:org.apache.camel.model.ErrorHandlerDefinition"), @YamlProperty(name="shutdownRoute", type="enum:Default,Defer", defaultValue="Default", description="To control how to shut down the route."), @YamlProperty(name="shutdownRunningTask", type="enum:CompleteCurrentTaskOnly,CompleteAllTasks", defaultValue="CompleteCurrentTaskOnly", description="To control how to shut down the route."), @YamlProperty(name="inputType", type="object:org.apache.camel.model.InputTypeDefinition"), @YamlProperty(name="outputType", type="object:org.apache.camel.model.OutputTypeDefinition"), @YamlProperty(name="from", type="object:org.apache.camel.model.FromDefinition", required=true)})
public class RouteDefinitionDeserializer
extends YamlDeserializerBase<RouteDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(RouteDefinitionDeserializer.class);

    public RouteDefinitionDeserializer() {
        super(RouteDefinition.class);
    }

    @Override
    protected RouteDefinition newInstance() {
        return new RouteDefinition();
    }

    @Override
    protected void setProperties(RouteDefinition target, MappingNode node) {
        YamlDeserializationContext dc = RouteDefinitionDeserializer.getDeserializationContext((Node)node);
        block46: for (NodeTuple tuple : node.getValue()) {
            String key = RouteDefinitionDeserializer.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            RouteDefinitionDeserializer.setDeserializationContext(val, dc);
            switch (key = StringHelper.dashToCamelCase((String)key)) {
                case "id": {
                    target.setId(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "description": {
                    target.setDescription(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "precondition": {
                    target.setPrecondition(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "group": {
                    target.setGroup(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "nodePrefixId": {
                    target.setNodePrefixId(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "routeConfigurationId": {
                    target.setRouteConfigurationId(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "autoStartup": {
                    target.setAutoStartup(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "routePolicy": {
                    target.setRoutePolicyRef(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "startupOrder": {
                    target.setStartupOrder(Integer.valueOf(RouteDefinitionDeserializer.asInt(val)));
                    continue block46;
                }
                case "streamCaching": {
                    LOG.warn("Old option name detected! Option streamCaching should be renamed to streamCache");
                    target.setStreamCache(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "streamCache": {
                    target.setStreamCache(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "logMask": {
                    target.setLogMask(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "messageHistory": {
                    target.setMessageHistory(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "shutdownRoute": {
                    target.setShutdownRoute(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "shutdownRunningTask": {
                    target.setShutdownRunningTask(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "trace": {
                    target.setTrace(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "errorHandlerRef": {
                    target.setErrorHandlerRef(RouteDefinitionDeserializer.asText(val));
                    continue block46;
                }
                case "errorHandler": {
                    target.setErrorHandler(RouteDefinitionDeserializer.asType(val, ErrorHandlerDefinition.class));
                    continue block46;
                }
                case "inputType": {
                    target.setInputType(RouteDefinitionDeserializer.asType(val, InputTypeDefinition.class));
                    continue block46;
                }
                case "outputType": {
                    target.setOutputType(RouteDefinitionDeserializer.asType(val, OutputTypeDefinition.class));
                    continue block46;
                }
                case "from": {
                    val.setProperty(RouteDefinition.class.getName(), (Object)target);
                    target.setInput(RouteDefinitionDeserializer.asType(val, FromDefinition.class));
                    continue block46;
                }
            }
            throw new UnsupportedFieldException((Node)node, key);
        }
    }
}

