/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.BeanModelHelper;
import org.apache.camel.model.Model;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"beans"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.model.BeanFactoryDefinition")})
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    public static final Logger LOG = LoggerFactory.getLogger(BeansDeserializer.class);
    private final Set<String> beanCache = new HashSet<String>();
    private final Map<String, KeyValueHolder<Object, String>> beansToDestroy = new LinkedHashMap<String, KeyValueHolder<Object, String>>();

    public Object construct(Node node) {
        BeansCustomizer answer = new BeansCustomizer();
        SequenceNode sn = BeansDeserializer.asSequenceNode(node);
        YamlDeserializationContext dc = BeansDeserializer.getDeserializationContext(node);
        for (Node item : sn.getValue()) {
            String key;
            boolean duplicate;
            BeansDeserializer.setDeserializationContext(item, dc);
            BeanFactoryDefinition bean = BeansDeserializer.asType(item, BeanFactoryDefinition.class);
            if (dc != null) {
                bean.setResource(dc.getResource());
            }
            ObjectHelper.notNull((Object)bean.getName(), (String)"The bean name must be set");
            ObjectHelper.notNull((Object)bean.getType(), (String)"The bean type must be set");
            if (!bean.getType().startsWith("#class:")) {
                bean.setType("#class:" + bean.getType());
            }
            if (bean.getScriptLanguage() != null || bean.getScript() != null) {
                ObjectHelper.notNull((Object)bean.getScriptLanguage(), (String)"The bean script language must be set");
                ObjectHelper.notNull((Object)bean.getScript(), (String)"The bean script must be set");
            }
            if (duplicate = this.beanCache.contains(key = bean.getName() + ":" + bean.getType())) continue;
            answer.addBean(bean);
            this.beanCache.add(key);
        }
        return answer;
    }

    public void clearCache() {
        this.beanCache.clear();
    }

    protected void registerBean(CamelContext camelContext, List<BeanFactoryDefinition<?>> delayedRegistrations, BeanFactoryDefinition<?> def, boolean delayIfFailed) {
        String name = def.getName();
        String type = def.getType();
        try {
            Object target = BeanModelHelper.newInstance(def, (CamelContext)camelContext);
            this.bindBean(camelContext, def, name, target);
        }
        catch (Exception e) {
            if (delayIfFailed) {
                delayedRegistrations.add(def);
            }
            String msg = name != null ? "Error creating bean: " + name + " of type: " + type : "Error creating bean: " + type;
            throw new RuntimeException(msg, e);
        }
    }

    protected void bindBean(CamelContext camelContext, BeanFactoryDefinition<?> def, String name, Object target) throws Exception {
        this.destroyBean(name, true);
        camelContext.getRegistry().unbind(name);
        String initMethod = def.getInitMethod();
        if (initMethod != null) {
            org.apache.camel.support.ObjectHelper.invokeMethodSafe((String)initMethod, (Object)target, (Object[])new Object[0]);
        }
        camelContext.getRegistry().bind(name, target);
        if (def.getDestroyMethod() != null) {
            this.beansToDestroy.put(name, (KeyValueHolder<Object, String>)new KeyValueHolder(target, (Object)def.getDestroyMethod()));
        }
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        model.addCustomBean(def);
    }

    protected void destroyBean(String name, boolean remove) {
        KeyValueHolder<Object, String> holder;
        KeyValueHolder<Object, String> keyValueHolder = holder = remove ? this.beansToDestroy.remove(name) : this.beansToDestroy.get(name);
        if (holder != null) {
            String destroyMethod = (String)holder.getValue();
            Object target = holder.getKey();
            try {
                org.apache.camel.support.ObjectHelper.invokeMethodSafe((String)destroyMethod, (Object)target, (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error invoking destroy method: {} on bean: {} due to: {}. This exception is ignored.", new Object[]{destroyMethod, target, e.getMessage(), e});
            }
        }
    }

    public void stop() throws Exception {
        for (String name : this.beansToDestroy.keySet()) {
            this.destroyBean(name, false);
        }
        this.beansToDestroy.clear();
    }

    private class BeansCustomizer
    implements CamelContextCustomizer {
        private final List<BeanFactoryDefinition<?>> delayedRegistrations = new ArrayList();
        private final List<BeanFactoryDefinition<?>> beans = new ArrayList();

        private BeansCustomizer() {
        }

        public void addBean(BeanFactoryDefinition<?> bean) {
            this.beans.add(bean);
        }

        public void configure(CamelContext camelContext) {
            for (BeanFactoryDefinition<?> bean : this.beans) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, true);
            }
            this.beans.clear();
            for (BeanFactoryDefinition<?> bean : this.delayedRegistrations) {
                BeansDeserializer.this.registerBean(camelContext, this.delayedRegistrations, bean, false);
            }
            this.delayedRegistrations.clear();
        }
    }
}

