/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.component.zeebe.model.ProcessRequest;
import org.apache.camel.component.zeebe.model.ProcessResponse;
import org.apache.camel.component.zeebe.processor.AbstractBaseProcessor;

public class ProcessProcessor
extends AbstractBaseProcessor {
    public ProcessProcessor(ZeebeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ProcessRequest message = null;
        if (exchange.getMessage().getBody() instanceof ProcessRequest) {
            message = (ProcessRequest)exchange.getMessage().getBody(ProcessRequest.class);
        } else if (exchange.getMessage().getBody() instanceof ProcessResponse) {
            message = new ProcessRequest();
            message.setProcessInstanceKey(((ProcessResponse)exchange.getMessage().getBody()).getProcessInstanceKey());
            message.setProcessId(((ProcessResponse)exchange.getMessage().getBody()).getProcessId());
            message.setProcessVersion(((ProcessResponse)exchange.getMessage().getBody()).getProcessVersion());
            message.setProcessKey(((ProcessResponse)exchange.getMessage().getBody()).getProcessKey());
        } else if (exchange.getMessage().getBody() instanceof String) {
            try {
                String bodyString = (String)exchange.getMessage().getBody(String.class);
                message = (ProcessRequest)this.objectMapper.readValue(bodyString, ProcessRequest.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalArgumentException("Cannot convert body to ProcessMessage", jsonProcessingException);
            }
        } else {
            throw new CamelException("Process data missing");
        }
        ProcessResponse resultMessage = null;
        switch (this.endpoint.getOperationName()) {
            case START_PROCESS: {
                resultMessage = this.startProcess(message);
                break;
            }
            case CANCEL_PROCESS: {
                resultMessage = this.cancelProcess(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Operation!");
            }
        }
        this.setBody(exchange, resultMessage, this.endpoint.isFormatJSON());
    }

    private ProcessResponse startProcess(ProcessRequest processMessage) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.startProcess(processMessage);
    }

    private ProcessResponse cancelProcess(ProcessRequest processMessage) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.cancelProcessInstance(processMessage);
    }
}

