/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cxf.soap.deployment;

import io.quarkiverse.cxf.deployment.CxfRouteRegistrationRequestorBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class CxfSoapProcessor {
    private static final String FEATURE = "camel-cxf-soap";

    CxfSoapProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    SystemPropertyBuildItem ehcacheAgentSizeOfBypass() {
        return new SystemPropertyBuildItem("org.ehcache.sizeof.AgentSizeOf.bypass", "true");
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        IndexView index = combinedIndex.getIndex();
        Stream.of("org.apache.wss4j.dom.handler.WSHandler").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownSubclasses(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> new ReflectiveClassBuildItem(false, false, new String[]{className})).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("org.apache.cxf.frontend.AbstractWSDLBasedEndpointFactory", "getServiceFactory", new String[0]));
    }

    @BuildStep
    CxfRouteRegistrationRequestorBuildItem requestCxfRouteRegistration() {
        return new CxfRouteRegistrationRequestorBuildItem(FEATURE);
    }
}

