/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kubernetes.cluster;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.apache.camel.cluster.CamelPreemptiveClusterService;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterService;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceConfig;
import org.apache.camel.support.cluster.RebalancingCamelClusterService;

@Recorder
public class KubernetesClusterServiceRecorder {
    public RuntimeValue<KubernetesClusterService> createKubernetesClusterService(KubernetesClusterServiceConfig config) {
        KubernetesClusterService kcs = this.setupKubernetesClusterServiceFromConfig(config);
        return new RuntimeValue((Object)kcs);
    }

    public RuntimeValue<RebalancingCamelClusterService> createKubernetesRebalancingClusterService(KubernetesClusterServiceConfig config) {
        KubernetesClusterService kcs = this.setupKubernetesClusterServiceFromConfig(config);
        RebalancingCamelClusterService rebalancingService = new RebalancingCamelClusterService((CamelPreemptiveClusterService)kcs, kcs.getRenewDeadlineMillis());
        return new RuntimeValue((Object)rebalancingService);
    }

    private KubernetesClusterService setupKubernetesClusterServiceFromConfig(KubernetesClusterServiceConfig config) {
        KubernetesClusterService clusterService = new KubernetesClusterService();
        config.id.ifPresent(id -> clusterService.setId(id));
        config.masterUrl.ifPresent(url -> clusterService.setMasterUrl(url));
        config.connectionTimeoutMillis.ifPresent(ctm -> clusterService.setConnectionTimeoutMillis(ctm));
        config.namespace.ifPresent(ns -> clusterService.setKubernetesNamespace(ns));
        config.podName.ifPresent(pn -> clusterService.setPodName(pn));
        config.jitterFactor.ifPresent(jf -> clusterService.setJitterFactor(jf.doubleValue()));
        config.leaseDurationMillis.ifPresent(ldm -> clusterService.setLeaseDurationMillis(ldm.longValue()));
        config.renewDeadlineMillis.ifPresent(rdm -> clusterService.setRenewDeadlineMillis(rdm.longValue()));
        config.retryPeriodMillis.ifPresent(rpm -> clusterService.setRetryPeriodMillis(rpm.longValue()));
        config.order.ifPresent(o -> clusterService.setOrder(o.intValue()));
        config.resourceName.ifPresent(krn -> clusterService.setKubernetesResourceName(krn));
        config.leaseResourceType.ifPresent(lrt -> clusterService.setLeaseResourceType(lrt));
        clusterService.setClusterLabels(config.labels);
        return clusterService;
    }
}

