/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.metrics.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import org.apache.camel.quarkus.component.microprofile.metrics.runtime.CamelMicroProfileMetricsConfig;
import org.apache.camel.quarkus.component.microprofile.metrics.runtime.CamelMicroProfileMetricsRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextCustomizerBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;
import org.eclipse.microprofile.metrics.MetricRegistry;

class MicroProfileMetricsProcessor {
    private static final String FEATURE = "camel-microprofile-metrics";

    MicroProfileMetricsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem metricRegistry(CamelMicroProfileMetricsRecorder recorder) {
        return new CamelBeanBuildItem("metricRegistry", MetricRegistry.class.getName(), recorder.createApplicationRegistry());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelContextCustomizerBuildItem contextCustomizer(CamelMicroProfileMetricsRecorder recorder, CamelMicroProfileMetricsConfig config) {
        return new CamelContextCustomizerBuildItem(recorder.createContextCustomizer(config));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    RuntimeCamelContextCustomizerBuildItem runtimeContextCustomizer(CamelMicroProfileMetricsRecorder recorder, CamelMicroProfileMetricsConfig config) {
        return new RuntimeCamelContextCustomizerBuildItem(recorder.createRuntimeContextCustomizer(config));
    }
}

