/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.trace;

import org.apache.camel.CamelContext;
import org.apache.camel.spi.BacklogTracer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.trace.CamelTraceConfigurationProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelTraceConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelTraceAutoConfiguration {
    @Bean
    public BacklogTracer backlogTracer(CamelContext camelContext, CamelTraceConfigurationProperties config) throws Exception {
        if (!config.isEnabled() && !config.isStandby()) {
            return null;
        }
        camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
        camelContext.setBacklogTracing(Boolean.valueOf(config.isEnabled()));
        camelContext.setBacklogTracingStandby(config.isStandby());
        camelContext.setBacklogTracingTemplates(config.isTraceTemplates());
        org.apache.camel.impl.debugger.BacklogTracer tracer = org.apache.camel.impl.debugger.BacklogTracer.createTracer((CamelContext)camelContext);
        tracer.setEnabled(config.isEnabled());
        tracer.setStandby(config.isStandby());
        tracer.setBacklogSize(config.getBacklogSize());
        tracer.setRemoveOnDump(config.isRemoveOnDump());
        tracer.setBodyMaxChars(config.getBodyMaxChars());
        tracer.setBodyIncludeStreams(config.isBodyIncludeStreams());
        tracer.setBodyIncludeFiles(config.isBodyIncludeFiles());
        tracer.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        tracer.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        tracer.setIncludeException(config.isIncludeException());
        tracer.setTraceRests(config.isTraceRests());
        tracer.setTraceTemplates(config.isTraceTemplates());
        tracer.setTracePattern(config.getTracePattern());
        tracer.setTraceFilter(config.getTraceFilter());
        camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, (Object)tracer);
        camelContext.addService((Object)tracer);
        return tracer;
    }
}

