/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.CFPropDefs;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;

public class AlterTableStatement {
    public final OperationType oType;
    public final String columnFamily;
    public final String columnName;
    public final String validator;
    private final CFPropDefs cfProps = new CFPropDefs();

    public AlterTableStatement(String columnFamily, OperationType type, String columnName) {
        this(columnFamily, type, columnName, null);
    }

    public AlterTableStatement(String columnFamily, OperationType type, String columnName, String validator) {
        this(columnFamily, type, columnName, validator, null);
    }

    public AlterTableStatement(String columnFamily, OperationType type, String columnName, String validator, Map<String, String> propertyMap) {
        this.columnFamily = columnFamily;
        this.oType = type;
        this.columnName = columnName;
        this.validator = CFPropDefs.comparators.get(validator);
        if (propertyMap != null) {
            for (Map.Entry<String, String> prop : propertyMap.entrySet()) {
                this.cfProps.addProperty(prop.getKey(), prop.getValue());
            }
        }
    }

    public CFMetaData getCFMetaData(String keyspace) throws ConfigurationException, InvalidRequestException, SyntaxException {
        CFMetaData meta = Schema.instance.getCFMetaData(keyspace, this.columnFamily);
        CFMetaData cfm = meta.copy();
        ByteBuffer columnName = this.oType == OperationType.OPTS ? null : meta.comparator.subtype(0).fromStringCQL2(this.columnName);
        switch (this.oType) {
            case ADD: {
                cfm.addColumnDefinition(ColumnDefinition.regularDef(cfm, columnName, TypeParser.parse(this.validator), null));
                break;
            }
            case ALTER: {
                ColumnDefinition partionKeyDef = cfm.partitionKeyColumns().get(0);
                if (partionKeyDef.name.bytes.equals(columnName)) {
                    cfm.keyValidator(TypeParser.parse(this.validator));
                    break;
                }
                ColumnDefinition toUpdate = null;
                for (ColumnDefinition columnDef : cfm.regularColumns()) {
                    if (!columnDef.name.bytes.equals(columnName)) continue;
                    toUpdate = columnDef;
                    break;
                }
                if (toUpdate == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                cfm.addOrReplaceColumnDefinition(toUpdate.withNewType(TypeParser.parse(this.validator)));
                break;
            }
            case DROP: {
                ColumnDefinition toDelete = null;
                for (ColumnDefinition columnDef : cfm.regularColumns()) {
                    if (!columnDef.name.bytes.equals(columnName)) continue;
                    toDelete = columnDef;
                }
                if (toDelete == null) {
                    throw new InvalidRequestException(String.format("Column '%s' was not found in CF '%s'", this.columnName, this.columnFamily));
                }
                cfm.removeColumnDefinition(toDelete);
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                AlterTableStatement.applyPropertiesToCFMetadata(cfm, this.cfProps);
            }
        }
        return cfm;
    }

    public String toString() {
        return String.format("AlterTableStatement(cf=%s, type=%s, column=%s, validator=%s)", new Object[]{this.columnFamily, this.oType, this.columnName, this.validator});
    }

    public static void applyPropertiesToCFMetadata(CFMetaData cfm, CFPropDefs cfProps) throws InvalidRequestException, ConfigurationException {
        if (cfProps.hasProperty("compaction_strategy_class").booleanValue()) {
            cfm.compactionStrategyClass(cfProps.compactionStrategyClass);
        }
        if (cfProps.hasProperty("comparator").booleanValue()) {
            throw new InvalidRequestException("Can't change CF comparator after creation");
        }
        if (cfProps.hasProperty("comment").booleanValue()) {
            cfm.comment(cfProps.getProperty("comment"));
        }
        if (cfProps.hasProperty("default_validation").booleanValue()) {
            try {
                cfm.defaultValidator(cfProps.getValidator());
            }
            catch (RequestValidationException e) {
                throw new InvalidRequestException(String.format("Invalid validation type %s", cfProps.getProperty("default_validation")));
            }
        }
        cfm.readRepairChance(cfProps.getPropertyDouble("read_repair_chance", cfm.getReadRepairChance()));
        cfm.dcLocalReadRepairChance(cfProps.getPropertyDouble("dclocal_read_repair_chance", cfm.getDcLocalReadRepair()));
        cfm.gcGraceSeconds(cfProps.getPropertyInt("gc_grace_seconds", cfm.getGcGraceSeconds()));
        int minCompactionThreshold = cfProps.getPropertyInt("min_compaction_threshold", cfm.getMinCompactionThreshold());
        int maxCompactionThreshold = cfProps.getPropertyInt("max_compaction_threshold", cfm.getMaxCompactionThreshold());
        if (minCompactionThreshold <= 0 || maxCompactionThreshold <= 0) {
            throw new ConfigurationException("Disabling compaction by setting compaction thresholds to 0 has been deprecated, set the compaction option 'enabled' to false instead.");
        }
        cfm.minCompactionThreshold(minCompactionThreshold);
        cfm.maxCompactionThreshold(maxCompactionThreshold);
        cfm.caching(CachingOptions.fromString(cfProps.getPropertyString("caching", cfm.getCaching().toString())));
        cfm.defaultTimeToLive(cfProps.getPropertyInt("default_time_to_live", cfm.getDefaultTimeToLive()));
        cfm.speculativeRetry(CFMetaData.SpeculativeRetry.fromString(cfProps.getPropertyString("speculative_retry", cfm.getSpeculativeRetry().toString())));
        cfm.bloomFilterFpChance(cfProps.getPropertyDouble("bloom_filter_fp_chance", cfm.getBloomFilterFpChance()));
        cfm.memtableFlushPeriod(cfProps.getPropertyInt("memtable_flush_period_in_ms", cfm.getMemtableFlushPeriod()));
        if (!cfProps.compactionStrategyOptions.isEmpty()) {
            cfm.compactionStrategyOptions(new HashMap<String, String>());
            for (Map.Entry<String, String> entry : cfProps.compactionStrategyOptions.entrySet()) {
                cfm.compactionStrategyOptions.put(entry.getKey(), entry.getValue());
            }
        }
        if (!cfProps.compressionParameters.isEmpty()) {
            cfm.compressionParameters(CompressionParameters.create(cfProps.compressionParameters));
        }
    }

    public static enum OperationType {
        ADD,
        ALTER,
        DROP,
        OPTS;

    }
}

