/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapper {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapper.class);
    protected final InetAddress address;
    protected final Collection<Token> tokens;
    protected final TokenMetadata tokenMetadata;

    public BootStrapper(InetAddress address, Collection<Token> tokens, TokenMetadata tmd) {
        assert (address != null);
        assert (tokens != null && !tokens.isEmpty());
        this.address = address;
        this.tokens = tokens;
        this.tokenMetadata = tmd;
    }

    public void bootstrap() {
        if (logger.isDebugEnabled()) {
            logger.debug("Beginning bootstrap process");
        }
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, this.tokens, this.address, "Bootstrap");
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
            AbstractReplicationStrategy strategy = Keyspace.open(keyspaceName).getReplicationStrategy();
            streamer.addRanges(keyspaceName, strategy.getPendingAddressRanges(this.tokenMetadata, this.tokens, this.address));
        }
        try {
            streamer.fetchAsync().get();
            StorageService.instance.finishBootstrapping();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting on boostrap to complete. Bootstrap will have to be restarted.");
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error during boostrap: " + e.getCause().getMessage(), e.getCause());
        }
    }

    public static Collection<Token> getBootstrapTokens(TokenMetadata metadata) throws ConfigurationException {
        Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
        if (initialTokens.size() > 0) {
            logger.debug("tokens manually specified as {}", initialTokens);
            ArrayList<Token> tokens = new ArrayList<Token>(initialTokens.size());
            for (String tokenString : initialTokens) {
                Token token = StorageService.getPartitioner().getTokenFactory().fromString(tokenString);
                if (metadata.getEndpoint(token) != null) {
                    throw new ConfigurationException("Bootstrapping to existing token " + tokenString + " is not allowed (decommission/removenode the old node first).");
                }
                tokens.add(token);
            }
            return tokens;
        }
        int numTokens = DatabaseDescriptor.getNumTokens();
        if (numTokens < 1) {
            throw new ConfigurationException("num_tokens must be >= 1");
        }
        if (numTokens == 1) {
            logger.warn("Picking random token for a single vnode.  You should probably add more vnodes; failing that, you should probably specify the token manually");
        }
        return BootStrapper.getRandomTokens(metadata, numTokens);
    }

    public static Collection<Token> getRandomTokens(TokenMetadata metadata, int numTokens) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Token token = StorageService.getPartitioner().getRandomToken();
            if (metadata.getEndpoint(token) != null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static class StringSerializer
    implements IVersionedSerializer<String> {
        public static final StringSerializer instance = new StringSerializer();

        @Override
        public void serialize(String s, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(s);
        }

        @Override
        public String deserialize(DataInput in, int version) throws IOException {
            return in.readUTF();
        }

        @Override
        public long serializedSize(String s, int version) {
            return TypeSizes.NATIVE.sizeof(s);
        }
    }
}

