/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.repair.IRequestCoordinator;
import org.apache.cassandra.repair.IRequestProcessor;

public class ParallelRequestCoordinator<R>
implements IRequestCoordinator<R> {
    private final Set<R> requests = new HashSet<R>();
    private final IRequestProcessor<R> processor;

    public ParallelRequestCoordinator(IRequestProcessor<R> processor) {
        this.processor = processor;
    }

    @Override
    public void add(R request) {
        this.requests.add(request);
    }

    @Override
    public void start() {
        for (R request : this.requests) {
            this.processor.process(request);
        }
    }

    @Override
    public int completed(R request) {
        this.requests.remove(request);
        return this.requests.size();
    }
}

