/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class AnticompactionRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new AnticompactionRequestSerializer();
    public final UUID parentRepairSession;

    public AnticompactionRequest(UUID parentRepairSession) {
        super(RepairMessage.Type.ANTICOMPACTION_REQUEST, null);
        this.parentRepairSession = parentRepairSession;
    }

    public static class AnticompactionRequestSerializer
    implements RepairMessage.MessageSerializer<AnticompactionRequest> {
        @Override
        public void serialize(AnticompactionRequest message, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(message.parentRepairSession, out, version);
        }

        @Override
        public AnticompactionRequest deserialize(DataInput in, int version) throws IOException {
            UUID parentRepairSession = UUIDSerializer.serializer.deserialize(in, version);
            return new AnticompactionRequest(parentRepairSession);
        }

        @Override
        public long serializedSize(AnticompactionRequest message, int version) {
            return UUIDSerializer.serializer.serializedSize(message.parentRepairSession, version);
        }
    }
}

