/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.UUIDGen;

public class Upgrader {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final LifecycleTransaction transaction;
    private final File directory;
    private final OperationType compactionType = OperationType.UPGRADE_SSTABLES;
    private final CompactionController controller;
    private final AbstractCompactionStrategy strategy;
    private final long estimatedRows;
    private final OutputHandler outputHandler;

    public Upgrader(ColumnFamilyStore cfs, LifecycleTransaction txn, OutputHandler outputHandler) {
        this.cfs = cfs;
        this.transaction = txn;
        this.sstable = txn.onlyOne();
        this.outputHandler = outputHandler;
        this.directory = new File(this.sstable.getFilename()).getParentFile();
        this.controller = new UpgradeController(cfs);
        this.strategy = cfs.getCompactionStrategy();
        long estimatedTotalKeys = Math.max((long)cfs.metadata.getMinIndexInterval(), SSTableReader.getApproximateKeyCount(Arrays.asList(this.sstable)));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(Arrays.asList(this.sstable)) / this.strategy.getMaxSSTableBytes());
        this.estimatedRows = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
    }

    private SSTableWriter createCompactionWriter(long repairedAt) {
        MetadataCollector sstableMetadataCollector = new MetadataCollector(this.cfs.getComparator());
        sstableMetadataCollector.addAncestor(this.sstable.descriptor.generation);
        for (Integer i : this.sstable.getAncestors()) {
            if (!new File(this.sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
            sstableMetadataCollector.addAncestor(i);
        }
        sstableMetadataCollector.sstableLevel(this.sstable.getSSTableLevel());
        return SSTableWriter.create(Descriptor.fromFilename(this.cfs.getTempSSTablePath(this.directory)), this.estimatedRows, (Long)repairedAt, this.cfs.metadata, this.cfs.partitioner, sstableMetadataCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        this.outputHandler.output("Upgrading " + this.sstable);
        try (SSTableRewriter writer = new SSTableRewriter(this.cfs, this.transaction, CompactionTask.getMaxDataAge(this.transaction.originals()), true);
             AbstractCompactionStrategy.ScannerList scanners = this.strategy.getScanners(this.transaction.originals());
             Iterator iter = new CompactionIterable(this.compactionType, scanners.scanners, this.controller, DatabaseDescriptor.getSSTableFormat(), UUIDGen.getTimeUUID()).iterator();){
            writer.switchWriter(this.createCompactionWriter(this.sstable.getSSTableMetadata().repairedAt));
            while (iter.hasNext()) {
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                writer.append(row);
            }
            writer.finish();
            this.outputHandler.output("Upgrade of " + this.sstable + " complete.");
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            this.controller.close();
        }
    }

    private static class UpgradeController
    extends CompactionController {
        public UpgradeController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MIN_VALUE;
        }
    }
}

