/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import java.util.Map;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="tpstats", description="Print usage statistics of thread pools")
public class TpStats
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        System.out.printf("%-25s%10s%10s%15s%10s%18s%n", "Pool Name", "Active", "Pending", "Completed", "Blocked", "All time blocked");
        for (Stage stage : Stage.jmxEnabledStages()) {
            System.out.printf("%-25s%10s%10s%15s%10s%18s%n", stage.getJmxName(), probe.getThreadPoolMetric(stage, "ActiveTasks"), probe.getThreadPoolMetric(stage, "PendingTasks"), probe.getThreadPoolMetric(stage, "CompletedTasks"), probe.getThreadPoolMetric(stage, "CurrentlyBlockedTasks"), probe.getThreadPoolMetric(stage, "TotalBlockedTasks"));
        }
        System.out.printf("%n%-20s%10s%n", "Message type", "Dropped");
        for (Map.Entry entry : probe.getDroppedMessages().entrySet()) {
            System.out.printf("%-20s%10s%n", entry.getKey(), entry.getValue());
        }
    }
}

