/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOException;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ObjectSizes;

public class IndexInfo {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new IndexInfo(null, null, 0L, 0L, null));
    public final long offset;
    public final long width;
    public final ClusteringPrefix firstName;
    public final ClusteringPrefix lastName;
    public final DeletionTime endOpenMarker;

    public IndexInfo(ClusteringPrefix firstName, ClusteringPrefix lastName, long offset, long width, DeletionTime endOpenMarker) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.offset = offset;
        this.width = width;
        this.endOpenMarker = endOpenMarker;
    }

    public long unsharedHeapSize() {
        return EMPTY_SIZE + this.firstName.unsharedHeapSize() + this.lastName.unsharedHeapSize() + (this.endOpenMarker == null ? 0L : this.endOpenMarker.unsharedHeapSize());
    }

    public static class Serializer
    implements ISerializer<IndexInfo> {
        public static final long WIDTH_BASE = 65536L;
        private final ISerializer<ClusteringPrefix> clusteringSerializer;
        private final Version version;

        public Serializer(Version version, ISerializer<ClusteringPrefix> clusteringSerializer) {
            this.clusteringSerializer = clusteringSerializer;
            this.version = version;
        }

        @Override
        public void serialize(IndexInfo info, DataOutputPlus out) throws IOException {
            assert (this.version.storeRows()) : "We read old index files but we should never write them";
            this.clusteringSerializer.serialize(info.firstName, out);
            this.clusteringSerializer.serialize(info.lastName, out);
            out.writeUnsignedVInt(info.offset);
            out.writeVInt(info.width - 65536L);
            out.writeBoolean(info.endOpenMarker != null);
            if (info.endOpenMarker != null) {
                DeletionTime.serializer.serialize(info.endOpenMarker, out);
            }
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            this.clusteringSerializer.skip(in);
            this.clusteringSerializer.skip(in);
            if (this.version.storeRows()) {
                in.readUnsignedVInt();
                in.readVInt();
                if (in.readBoolean()) {
                    DeletionTime.serializer.skip(in);
                }
            } else {
                in.skipBytes(TypeSizes.sizeof(0L));
                in.skipBytes(TypeSizes.sizeof(0L));
            }
        }

        @Override
        public IndexInfo deserialize(DataInputPlus in) throws IOException {
            long width;
            long offset;
            ClusteringPrefix firstName = this.clusteringSerializer.deserialize(in);
            ClusteringPrefix lastName = this.clusteringSerializer.deserialize(in);
            DeletionTime endOpenMarker = null;
            if (this.version.storeRows()) {
                offset = in.readUnsignedVInt();
                width = in.readVInt() + 65536L;
                if (in.readBoolean()) {
                    endOpenMarker = DeletionTime.serializer.deserialize(in);
                }
            } else {
                offset = in.readLong();
                width = in.readLong();
            }
            return new IndexInfo(firstName, lastName, offset, width, endOpenMarker);
        }

        @Override
        public long serializedSize(IndexInfo info) {
            assert (this.version.storeRows()) : "We read old index files but we should never write them";
            long size = this.clusteringSerializer.serializedSize(info.firstName) + this.clusteringSerializer.serializedSize(info.lastName) + (long)TypeSizes.sizeofUnsignedVInt(info.offset) + (long)TypeSizes.sizeofVInt(info.width - 65536L) + (long)TypeSizes.sizeof(info.endOpenMarker != null);
            if (info.endOpenMarker != null) {
                size += DeletionTime.serializer.serializedSize(info.endOpenMarker);
            }
            return size;
        }
    }
}

