/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.UUIDGen;

public class ExecuteMessage
extends Message.Request {
    private static final NoSpamLogger nospam = NoSpamLogger.getLogger(logger, 10L, TimeUnit.MINUTES);
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ByteBuf body, ProtocolVersion version) {
            byte[] id = CBUtil.readBytes(body);
            return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(ExecuteMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeBytes(msg.statementId.bytes, dest);
            if (version == ProtocolVersion.V1) {
                CBUtil.writeValueList(msg.options.getValues(), dest);
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(ExecuteMessage msg, ProtocolVersion version) {
            int size = 0;
            size += CBUtil.sizeOfBytes(msg.statementId.bytes);
            if (version == ProtocolVersion.V1) {
                size += CBUtil.sizeOfValueList(msg.options.getValues());
                size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency());
            } else {
                size += QueryOptions.codec.encodedSize(msg.options, version);
            }
            return size;
        }
    };
    public final MD5Digest statementId;
    public final QueryOptions options;

    public ExecuteMessage(MD5Digest statementId, QueryOptions options) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state, long queryStartNanoTime) {
        try {
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ParsedStatement.Prepared prepared = handler.getPrepared(this.statementId);
            if (prepared != null && !prepared.fullyQualified && !Objects.equals(state.getClientState().getRawKeyspace(), prepared.keyspace) && (prepared.statement instanceof ModificationStatement || prepared.statement instanceof SelectStatement)) {
                state.getClientState().warnAboutUseWithPreparedStatements(this.statementId, prepared.keyspace);
                String msg = String.format("Tried to execute a prepared unqalified statement on a keyspace it was not prepared on.  Executing the resulting prepared statement will return unexpected results: %s (on keyspace %s, previously prepared on %s)", this.statementId, state.getClientState().getRawKeyspace(), prepared.keyspace);
                nospam.error(msg, new Object[0]);
            }
            if (prepared == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            this.options.prepare(prepared.boundNames);
            CQLStatement statement = prepared.statement;
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession(this.getCustomPayload());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (this.options.getPageSize() > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
                }
                if (this.options.getConsistency() != null) {
                    builder.put((Object)"consistency_level", (Object)this.options.getConsistency().name());
                }
                if (this.options.getSerialConsistency() != null) {
                    builder.put((Object)"serial_consistency_level", (Object)this.options.getSerialConsistency().name());
                }
                builder.put((Object)"query", (Object)prepared.rawCQLStatement);
                for (int i = 0; i < prepared.boundNames.size(); ++i) {
                    ColumnSpecification cs = prepared.boundNames.get(i);
                    String boundName = cs.name.toString();
                    String boundValue = cs.type.asCQL3Type().toCQLLiteral(this.options.getValues().get(i), this.options.getProtocolVersion());
                    if (boundValue.length() > 1000) {
                        boundValue = boundValue.substring(0, 1000) + "...'";
                    }
                    builder.put((Object)("bound_var_" + Integer.toString(i) + "_" + boundName), (Object)boundValue);
                }
                Tracing.instance.begin("Execute CQL3 prepared query", state.getClientAddress(), (Map<String, String>)builder.build());
            }
            QueryOptions queryOptions = QueryOptions.addColumnSpecifications(this.options, prepared.boundNames);
            ResultMessage response = handler.processPrepared(statement, state, queryOptions, this.getCustomPayload(), queryStartNanoTime);
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.options.getValues().size() + " values at consistency " + (Object)((Object)this.options.getConsistency());
    }
}

