/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MBeanWrapper {
    public static final Logger logger = LoggerFactory.getLogger(MBeanWrapper.class);
    public static final MBeanWrapper instance = MBeanWrapper.create();
    public static final String IS_DISABLED_MBEAN_REGISTRATION = "org.apache.cassandra.disable_mbean_registration";
    public static final String DTEST_IS_IN_JVM_DTEST = "org.apache.cassandra.dtest.is_in_jvm_dtest";
    public static final String MBEAN_REGISTRATION_CLASS = "org.apache.cassandra.mbean_registration_class";

    public static MBeanWrapper create() {
        if (Boolean.getBoolean(DTEST_IS_IN_JVM_DTEST)) {
            return new DelegatingMbeanWrapper(MBeanWrapper.getMBeanWrapper());
        }
        return MBeanWrapper.getMBeanWrapper();
    }

    public static MBeanWrapper getMBeanWrapper() {
        if (Boolean.getBoolean(IS_DISABLED_MBEAN_REGISTRATION)) {
            return new NoOpMBeanWrapper();
        }
        String klass = System.getProperty(MBEAN_REGISTRATION_CLASS);
        if (klass == null) {
            if (Boolean.getBoolean(DTEST_IS_IN_JVM_DTEST)) {
                return new NoOpMBeanWrapper();
            }
            return new PlatformMBeanWrapper();
        }
        return (MBeanWrapper)FBUtilities.construct(klass, "mbean");
    }

    public static ObjectName create(String mbeanName, OnException onException) {
        try {
            return new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            onException.handler.accept(e);
            return null;
        }
    }

    public void registerMBean(Object var1, ObjectName var2, OnException var3);

    default public void registerMBean(Object obj, ObjectName mbeanName) {
        this.registerMBean(obj, mbeanName, OnException.THROW);
    }

    default public void registerMBean(Object obj, String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return;
        }
        this.registerMBean(obj, name, onException);
    }

    default public void registerMBean(Object obj, String mbeanName) {
        this.registerMBean(obj, mbeanName, OnException.THROW);
    }

    public boolean isRegistered(ObjectName var1, OnException var2);

    default public boolean isRegistered(ObjectName mbeanName) {
        return this.isRegistered(mbeanName, OnException.THROW);
    }

    default public boolean isRegistered(String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return false;
        }
        return this.isRegistered(name, onException);
    }

    default public boolean isRegistered(String mbeanName) {
        return this.isRegistered(mbeanName, OnException.THROW);
    }

    public void unregisterMBean(ObjectName var1, OnException var2);

    default public void unregisterMBean(ObjectName mbeanName) {
        this.unregisterMBean(mbeanName, OnException.THROW);
    }

    default public void unregisterMBean(String mbeanName, OnException onException) {
        ObjectName name = MBeanWrapper.create(mbeanName, onException);
        if (name == null) {
            return;
        }
        this.unregisterMBean(name, onException);
    }

    default public void unregisterMBean(String mbeanName) {
        this.unregisterMBean(mbeanName, OnException.THROW);
    }

    public Set<ObjectName> queryNames(ObjectName var1, QueryExp var2);

    public MBeanServer getMBeanServer();

    public static class DelegatingMbeanWrapper
    implements MBeanWrapper {
        MBeanWrapper delegate;

        public DelegatingMbeanWrapper(MBeanWrapper mBeanWrapper) {
            this.delegate = mBeanWrapper;
        }

        public MBeanWrapper getDelegate() {
            return this.delegate;
        }

        public void setDelegate(MBeanWrapper wrapper) {
            this.delegate = wrapper;
        }

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
            try {
                this.delegate.registerMBean(obj, mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            try {
                return this.delegate.isRegistered(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
            try {
                this.delegate.unregisterMBean(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.delegate.queryNames(name, query);
        }

        @Override
        public MBeanServer getMBeanServer() {
            return this.delegate.getMBeanServer();
        }
    }

    public static class InstanceMBeanWrapper
    implements MBeanWrapper {
        private MBeanServer mbs;
        public final UUID id = UUID.randomUUID();

        public InstanceMBeanWrapper(String hostname) {
            this.mbs = MBeanServerFactory.createMBeanServer(hostname + "-" + this.id);
        }

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.registerMBean(obj, mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            try {
                return this.mbs.isRegistered(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.unregisterMBean(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.mbs.queryNames(name, query);
        }

        @Override
        public MBeanServer getMBeanServer() {
            return this.mbs;
        }

        public void close() {
            this.mbs.queryNames(null, null).forEach(name -> {
                try {
                    if (!name.getCanonicalName().contains("MBeanServerDelegate")) {
                        this.mbs.unregisterMBean((ObjectName)name);
                    }
                }
                catch (Throwable e) {
                    logger.debug("Could not unregister mbean {}", (Object)name.getCanonicalName());
                }
            });
            MBeanServerFactory.releaseMBeanServer(this.mbs);
            this.mbs = null;
        }
    }

    public static class PlatformMBeanWrapper
    implements MBeanWrapper {
        private final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.registerMBean(obj, mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            try {
                return this.mbs.isRegistered(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
                return false;
            }
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
            try {
                this.mbs.unregisterMBean(mbeanName);
            }
            catch (Exception e) {
                onException.handler.accept(e);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.mbs.queryNames(name, query);
        }

        @Override
        public MBeanServer getMBeanServer() {
            return this.mbs;
        }
    }

    public static class NoOpMBeanWrapper
    implements MBeanWrapper {
        @Override
        public void registerMBean(Object obj, ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void registerMBean(Object obj, String mbeanName, OnException onException) {
        }

        @Override
        public boolean isRegistered(ObjectName mbeanName, OnException onException) {
            return false;
        }

        @Override
        public boolean isRegistered(String mbeanName, OnException onException) {
            return false;
        }

        @Override
        public void unregisterMBean(ObjectName mbeanName, OnException onException) {
        }

        @Override
        public void unregisterMBean(String mbeanName, OnException onException) {
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return Collections.emptySet();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return null;
        }
    }

    public static enum OnException {
        THROW(e -> {
            throw new RuntimeException((Throwable)e);
        }),
        LOG(e -> logger.error("Error in MBean wrapper: ", (Throwable)e)),
        IGNORE(e -> {});

        private Consumer<Exception> handler;

        private OnException(Consumer<Exception> handler) {
            this.handler = handler;
        }
    }
}

