/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TokenRange;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.utils.FBUtilities;

public class NativeSSTableLoaderClient
extends SSTableLoader.Client {
    protected final Map<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
    private final Collection<InetAddress> hosts;
    private final int port;
    private final AuthProvider authProvider;
    private final SSLOptions sslOptions;

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, String username, String password, SSLOptions sslOptions) {
        this(hosts, port, (AuthProvider)new PlainTextAuthProvider(username, password), sslOptions);
    }

    public NativeSSTableLoaderClient(Collection<InetAddress> hosts, int port, AuthProvider authProvider, SSLOptions sslOptions) {
        this.hosts = hosts;
        this.port = port;
        this.authProvider = authProvider;
        this.sslOptions = sslOptions;
    }

    @Override
    public void init(String keyspace) {
        Cluster.Builder builder = Cluster.builder().addContactPoints(this.hosts).withPort(this.port);
        if (this.sslOptions != null) {
            builder.withSSL(this.sslOptions);
        }
        if (this.authProvider != null) {
            builder = builder.withAuthProvider(this.authProvider);
        }
        try (Cluster cluster = builder.build();
             Session session = cluster.connect();){
            Metadata metadata = cluster.getMetadata();
            Set tokenRanges = metadata.getTokenRanges();
            IPartitioner partitioner = FBUtilities.newPartitioner(metadata.getPartitioner());
            Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
            for (TokenRange tokenRange : tokenRanges) {
                Set endpoints = metadata.getReplicas(Metadata.quote((String)keyspace), tokenRange);
                Range<Token> range = new Range<Token>(tokenFactory.fromString(tokenRange.getStart().getValue().toString()), tokenFactory.fromString(tokenRange.getEnd().getValue().toString()));
                for (Host endpoint : endpoints) {
                    this.addRangeForEndpoint(range, endpoint.getBroadcastAddress());
                }
            }
            Types types = NativeSSTableLoaderClient.fetchTypes(keyspace, session);
            this.tables.putAll(NativeSSTableLoaderClient.fetchTables(keyspace, session, partitioner, types));
            this.tables.putAll(NativeSSTableLoaderClient.fetchViews(keyspace, session, partitioner, types));
        }
    }

    @Override
    public CFMetaData getTableMetadata(String tableName) {
        return this.tables.get(tableName);
    }

    @Override
    public void setTableMetadata(CFMetaData cfm) {
        this.tables.put(cfm.cfName, cfm);
    }

    private static Types fetchTypes(String keyspace, Session session) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "types");
        Types.RawBuilder types = Types.rawBuilder(keyspace);
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("type_name");
            List fieldNames = row.getList("field_names", String.class);
            List fieldTypes = row.getList("field_types", String.class);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Map<String, CFMetaData> fetchTables(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "tables");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("table_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, false, row, name, types));
        }
        return tables;
    }

    private static Map<String, CFMetaData> fetchViews(String keyspace, Session session, IPartitioner partitioner, Types types) {
        HashMap<String, CFMetaData> tables = new HashMap<String, CFMetaData>();
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", "system_schema", "views");
        for (Row row : session.execute(query, new Object[]{keyspace})) {
            String name = row.getString("view_name");
            tables.put(name, NativeSSTableLoaderClient.createTableMetadata(keyspace, session, partitioner, true, row, name, types));
        }
        return tables;
    }

    private static CFMetaData createTableMetadata(String keyspace, Session session, IPartitioner partitioner, boolean isView, Row row, String name, Types types) {
        UUID id = row.getUUID("id");
        Set flags = isView ? Collections.emptySet() : CFMetaData.flagsFromStrings(row.getSet("flags", String.class));
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = isView || flags.contains((Object)CFMetaData.Flag.COMPOUND);
        String columnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "columns");
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        for (Row colRow : session.execute(columnsQuery, new Object[]{keyspace, name})) {
            defs.add(NativeSSTableLoaderClient.createDefinitionFromRow(colRow, keyspace, name, types));
        }
        CFMetaData metadata = CFMetaData.create(keyspace, name, id, isDense, isCompound, isSuper, isCounter, isView, defs, partitioner);
        String droppedColumnsQuery = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", "system_schema", "dropped_columns");
        HashMap<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = new HashMap<ByteBuffer, CFMetaData.DroppedColumn>();
        for (Row colRow : session.execute(droppedColumnsQuery, new Object[]{keyspace, name})) {
            CFMetaData.DroppedColumn droppedColumn = NativeSSTableLoaderClient.createDroppedColumnFromRow(colRow, keyspace);
            droppedColumns.put(UTF8Type.instance.decompose(droppedColumn.name), droppedColumn);
        }
        metadata.droppedColumns(droppedColumns);
        return metadata;
    }

    private static ColumnDefinition createDefinitionFromRow(Row row, String keyspace, String table, Types types) {
        ColumnDefinition.ClusteringOrder order = ColumnDefinition.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), types);
        if (order == ColumnDefinition.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        ColumnIdentifier name = new ColumnIdentifier(row.getBytes("column_name_bytes"), row.getString("column_name"));
        int position = row.getInt("position");
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("kind").toUpperCase());
        return new ColumnDefinition(keyspace, table, name, type, position, kind);
    }

    private static CFMetaData.DroppedColumn createDroppedColumnFromRow(Row row, String keyspace) {
        String name = row.getString("column_name");
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), Types.none());
        long droppedTime = TimeUnit.MILLISECONDS.toMicros(row.getTimestamp("dropped_time").getTime());
        return new CFMetaData.DroppedColumn(name, type, droppedTime);
    }
}

