/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.commons.lang3.StringUtils;

public class FunctionResource
implements IResource {
    private static final Set<Permission> COLLECTION_LEVEL_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.CREATE, (Enum[])new Permission[]{Permission.ALTER, Permission.DROP, Permission.AUTHORIZE, Permission.EXECUTE});
    private static final Set<Permission> SCALAR_FUNCTION_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.ALTER, (Enum[])new Permission[]{Permission.DROP, Permission.AUTHORIZE, Permission.EXECUTE});
    private static final Set<Permission> AGGREGATE_FUNCTION_PERMISSIONS = Sets.immutableEnumSet((Enum)Permission.ALTER, (Enum[])new Permission[]{Permission.DROP, Permission.AUTHORIZE, Permission.EXECUTE});
    private static final String ROOT_NAME = "functions";
    private static final FunctionResource ROOT_RESOURCE = new FunctionResource();
    private final Level level;
    private final String keyspace;
    private final String name;
    private final List<AbstractType<?>> argTypes;

    private FunctionResource() {
        this.level = Level.ROOT;
        this.keyspace = null;
        this.name = null;
        this.argTypes = null;
    }

    private FunctionResource(String keyspace) {
        this.level = Level.KEYSPACE;
        this.keyspace = keyspace;
        this.name = null;
        this.argTypes = null;
    }

    private FunctionResource(String keyspace, String name, List<AbstractType<?>> argTypes) {
        this.level = Level.FUNCTION;
        this.keyspace = keyspace;
        this.name = name;
        this.argTypes = argTypes;
    }

    public static FunctionResource root() {
        return ROOT_RESOURCE;
    }

    public static FunctionResource keyspace(String keyspace) {
        return new FunctionResource(keyspace);
    }

    public static FunctionResource function(String keyspace, String name, List<AbstractType<?>> argTypes) {
        return new FunctionResource(keyspace, name, argTypes);
    }

    public static FunctionResource functionFromCql(String keyspace, String name, List<CQL3Type.Raw> argTypes) {
        if (keyspace == null) {
            throw new InvalidRequestException("In this context function name must be explictly qualified by a keyspace");
        }
        ArrayList abstractTypes = new ArrayList();
        for (CQL3Type.Raw cqlType : argTypes) {
            abstractTypes.add(cqlType.prepare(keyspace).getType());
        }
        return new FunctionResource(keyspace, name, abstractTypes);
    }

    public static FunctionResource fromName(String name) {
        String[] parts = StringUtils.split((String)name, (char)'/');
        if (!parts[0].equals(ROOT_NAME) || parts.length > 3) {
            throw new IllegalArgumentException(String.format("%s is not a valid function resource name", name));
        }
        if (parts.length == 1) {
            return FunctionResource.root();
        }
        if (parts.length == 2) {
            return FunctionResource.keyspace(parts[1]);
        }
        String[] nameAndArgs = StringUtils.split((String)parts[2], (String)"[|]");
        return FunctionResource.function(parts[1], nameAndArgs[0], FunctionResource.argsListFromString(nameAndArgs[1]));
    }

    @Override
    public String getName() {
        switch (this.level) {
            case ROOT: {
                return ROOT_NAME;
            }
            case KEYSPACE: {
                return String.format("%s/%s", ROOT_NAME, this.keyspace);
            }
            case FUNCTION: {
                return String.format("%s/%s/%s[%s]", ROOT_NAME, this.keyspace, this.name, this.argListAsString());
            }
        }
        throw new AssertionError();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public FunctionName getFunctionName() {
        if (this.level != Level.FUNCTION) {
            throw new IllegalStateException(String.format("%s function resource has no function name", new Object[]{this.level}));
        }
        return new FunctionName(this.keyspace, this.name);
    }

    @Override
    public IResource getParent() {
        switch (this.level) {
            case KEYSPACE: {
                return FunctionResource.root();
            }
            case FUNCTION: {
                return FunctionResource.keyspace(this.keyspace);
            }
        }
        throw new IllegalStateException("Root-level resource can't have a parent");
    }

    @Override
    public boolean hasParent() {
        return this.level != Level.ROOT;
    }

    @Override
    public boolean exists() {
        switch (this.level) {
            case ROOT: {
                return true;
            }
            case KEYSPACE: {
                return Schema.instance.getKeyspaces().contains(this.keyspace);
            }
            case FUNCTION: {
                return Schema.instance.findFunction(this.getFunctionName(), this.argTypes).isPresent();
            }
        }
        throw new AssertionError();
    }

    @Override
    public Set<Permission> applicablePermissions() {
        switch (this.level) {
            case ROOT: 
            case KEYSPACE: {
                return COLLECTION_LEVEL_PERMISSIONS;
            }
            case FUNCTION: {
                Optional<Function> function = Schema.instance.findFunction(this.getFunctionName(), this.argTypes);
                assert (function.isPresent()) : "Unable to find function object for resource " + this.toString();
                return function.get().isAggregate() ? AGGREGATE_FUNCTION_PERMISSIONS : SCALAR_FUNCTION_PERMISSIONS;
            }
        }
        throw new AssertionError();
    }

    public int compareTo(FunctionResource o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        switch (this.level) {
            case ROOT: {
                return "<all functions>";
            }
            case KEYSPACE: {
                return String.format("<all functions in %s>", this.keyspace);
            }
            case FUNCTION: {
                return String.format("<function %s.%s(%s)>", this.keyspace, this.name, Joiner.on((String)", ").join(AbstractType.asCQLTypeStringList(this.argTypes)));
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionResource)) {
            return false;
        }
        FunctionResource f = (FunctionResource)o;
        return Objects.equal((Object)((Object)this.level), (Object)((Object)f.level)) && Objects.equal((Object)this.keyspace, (Object)f.keyspace) && Objects.equal((Object)this.name, (Object)f.name) && Objects.equal(this.argTypes, f.argTypes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.keyspace, this.name, this.argTypes});
    }

    private String argListAsString() {
        return Joiner.on((String)"^").join(this.argTypes);
    }

    private static List<AbstractType<?>> argsListFromString(String s) {
        ArrayList argTypes = new ArrayList();
        for (String type : Splitter.on((String)"^").omitEmptyStrings().trimResults().split((CharSequence)s)) {
            argTypes.add(TypeParser.parse(type));
        }
        return argTypes;
    }

    static enum Level {
        ROOT,
        KEYSPACE,
        FUNCTION;

    }
}

