/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class ReplayPosition
implements Comparable<ReplayPosition> {
    public static final ReplayPositionSerializer serializer = new ReplayPositionSerializer();
    public static final ReplayPosition NONE = new ReplayPosition(-1L, 0);
    public final long segment;
    public final int position;

    public static ReplayPosition firstNotCovered(Iterable<ReplayFilter> ranges) {
        ReplayPosition min = null;
        for (ReplayFilter map : ranges) {
            ReplayPosition first = map.persisted.firstEntry().getValue();
            if (min == null) {
                min = first;
                continue;
            }
            min = (ReplayPosition)Ordering.natural().min((Object)min, (Object)first);
        }
        if (min == null) {
            return NONE;
        }
        return min;
    }

    public ReplayPosition(long segment, int position) {
        this.segment = segment;
        assert (position >= 0);
        this.position = position;
    }

    @Override
    public int compareTo(ReplayPosition that) {
        if (this.segment != that.segment) {
            return Long.compare(this.segment, that.segment);
        }
        return Integer.compare(this.position, that.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayPosition that = (ReplayPosition)o;
        if (this.position != that.position) {
            return false;
        }
        return this.segment == that.segment;
    }

    public int hashCode() {
        int result = (int)(this.segment ^ this.segment >>> 32);
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        return "ReplayPosition(segmentId=" + this.segment + ", position=" + this.position + ')';
    }

    public ReplayPosition clone() {
        return new ReplayPosition(this.segment, this.position);
    }

    public static class ReplayPositionSerializer
    implements ISerializer<ReplayPosition> {
        @Override
        public void serialize(ReplayPosition rp, DataOutputPlus out) throws IOException {
            out.writeLong(rp.segment);
            out.writeInt(rp.position);
        }

        @Override
        public ReplayPosition deserialize(DataInputPlus in) throws IOException {
            return new ReplayPosition(in.readLong(), in.readInt());
        }

        @Override
        public long serializedSize(ReplayPosition rp) {
            return TypeSizes.sizeof(rp.segment) + TypeSizes.sizeof(rp.position);
        }
    }

    public static class ReplayFilter {
        final NavigableMap<ReplayPosition, ReplayPosition> persisted = new TreeMap<ReplayPosition, ReplayPosition>();

        public ReplayFilter(Iterable<SSTableReader> onDisk, ReplayPosition truncatedAt) {
            for (SSTableReader reader : onDisk) {
                ReplayPosition start = reader.getSSTableMetadata().commitLogLowerBound;
                ReplayPosition end = reader.getSSTableMetadata().commitLogUpperBound;
                ReplayFilter.add(this.persisted, start, end);
            }
            if (truncatedAt != null) {
                ReplayFilter.add(this.persisted, NONE, truncatedAt);
            }
        }

        private static void add(NavigableMap<ReplayPosition, ReplayPosition> ranges, ReplayPosition start, ReplayPosition end) {
            Map.Entry<ReplayPosition, ReplayPosition> extend = ranges.floorEntry(end);
            if (extend != null && extend.getValue().compareTo(end) > 0) {
                end = extend.getValue();
            }
            if ((extend = ranges.lowerEntry(start)) != null && extend.getValue().compareTo(start) >= 0) {
                start = extend.getKey();
            }
            ranges.subMap(start, end).clear();
            ranges.put(start, end);
        }

        public boolean shouldReplay(ReplayPosition position) {
            Map.Entry<ReplayPosition, ReplayPosition> range = this.persisted.lowerEntry(position);
            return range == null || position.compareTo(range.getValue()) > 0;
        }

        public boolean isEmpty() {
            return this.persisted.isEmpty();
        }
    }
}

